/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.permissions;


import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;

import java.math.BigDecimal;

/**
 * This class is mainly instantiated from a PageState It is very
 * context specific for permissions. It tries to read the
 * object_id and load the corresponding ACSObject, as well as
 * the party_id and the corresponding entity.
 *
 * @author Stefan Deusch (sdeusch@arsdigita.com)
 * @version $id$
 */
class CMSUserObjectStruct implements CMSPermissionsConstants {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/permissions/CMSUserObjectStruct.java#11 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (CMSUserObjectStruct.class);

    private Party m_party;
    private ACSObject m_object;

    CMSUserObjectStruct(PageState s, ACSObjectSelectionModel model) {
        this(getParty(s), getObject(s, model));
    }

    CMSUserObjectStruct(BigDecimal partyID, BigDecimal objectID){
        this(loadParty(partyID), loadObject(objectID));
    }

    CMSUserObjectStruct(Party p, ACSObject o) {
        m_party  = p;
        m_object = o;
    }

    Party getParty() {
        return m_party;
    }

    ACSObject getObject() {
        return m_object;
    }

    // Utility factory methods

    static ACSObject loadObject(BigDecimal id) {
        ACSObject obj = null;
        try {
            obj = (ACSObject) DomainObjectFactory
                .newInstance(new OID(ACSObject.BASE_DATA_OBJECT_TYPE, id));
        } catch(DataObjectNotFoundException e) {
            throw new UncheckedWrapperException( (String) GlobalizationUtil.globalize("cms.ui.permissions.could_not_find_this_object").localize(), e);
        }
        return obj;
    }

    static ACSObject loadObject(OID oid) {
        ACSObject obj = null;
        try {
            obj = (ACSObject) DomainObjectFactory.newInstance(oid);
        } catch(DataObjectNotFoundException e) {
            throw new UncheckedWrapperException( (String) GlobalizationUtil.globalize("cms.ui.permissions.could_not_find_this_object").localize() + oid, e);
        }
        return obj;
    }

    // use in package

    static Party loadParty(BigDecimal id) {
        Party party = null;
        try {
            party = User.retrieve(id);
        } catch(DataObjectNotFoundException e1) {
            // ok, then try to load a group
            try {
                party = new Group(id);
            } catch(DataObjectNotFoundException e2) {
                throw new UncheckedWrapperException("No User in Database with the " +
                                           "id " + id, e2);
            }
        }
        return party;
    }

    public static Party getParty(PageState s) {
        return Kernel.getContext().getParty();
    }

    public static ACSObject getObject(PageState s, ACSObjectSelectionModel model) {
        return (ACSObject) model.getSelectedObject(s);
    }

}
