/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.Folder;
import org.apache.log4j.Logger;

class FolderAddForm extends FolderBaseForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderAddForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(FolderAddForm.class);

    private final SingleSelectionModel m_model;
    private final FolderRequestLocal m_parent;

    public FolderAddForm(final SingleSelectionModel model,
                         final FolderRequestLocal parent) {
        super("folder-add");
        
        m_model = model;
        m_parent = parent;

        m_fragment.addValidationListener
            (new ChildUniqueValidationListener(parent));

        addProcessListener(new ProcessListener());
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            final Folder folder = new Folder();

            folder.setParent(m_parent.getFolder(state));
            folder.setLabel((String) m_title.getValue(state));
            folder.setName((String) m_fragment.getValue(state));

            folder.save();

            m_model.setSelectedKey(state, folder.getID().toString());
        }
    }
}
