/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.LockableImpl;

import java.util.Collection;


/**
 * A List of all purposes for the current category.
 *
 * @author Scott Seago (scott@arsdigita.com)
 * @version $Revision: #10 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class PurposesList extends List {

    public final static String PURPOSES_LIST = "pl";

    private final CategoryRequestLocal m_category;

    public PurposesList(final CategoryRequestLocal category) {
        super(new ParameterSingleSelectionModel
              (new BigDecimalParameter(PURPOSES_LIST)));
        setIdAttr("purposes_list");

        m_category = category;

        setModelBuilder(new CategoryPurposesModelBuilder());
        setCellRenderer(new ListCellRenderer() {

                public Component getComponent(List list, PageState state, Object value,
                                              String key, int index, boolean isSelected)
                {
                    return new Label(value.toString());
                }
            });

        Label l = new Label(GlobalizationUtil.globalize
                            ("cms.ui.category.purpose.none"));
        l.setFontWeight(Label.ITALIC);
        setEmptyView(l);
    }

    private class CategoryPurposesModelBuilder extends LockableImpl
        implements ListModelBuilder {

        public CategoryPurposesModelBuilder() {
            super();
        }

        public ListModel makeModel(List l, PageState state) {
            Category category = m_category.getCategory(state);
            if ( category != null && !category.isRoot() ) {

                Collection purposes = category.getPurposes();
                return new CategoryPurposeIteratorListModel(purposes.iterator());

            } else {
                return List.EMPTY_MODEL;
            }
        }
    }

}
