/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.categorization.Category;

import java.util.Iterator;

/**
 * A {@link ListModel} that iterates over categories via an iterator
 */
public class CategoryIteratorListModel implements ListModel {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryIteratorListModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Iterator m_iter;
    private Category m_cat;

    /**
     * Construct a new <code>CategoryIteratorListModel</code>
     *
     * @param iter an {@link Iterator} over all the categories
     *   which this model will supply
     */
    public CategoryIteratorListModel(Iterator iter) {
        m_iter = iter;
        m_cat = null;
    }

    public boolean next() {
        if(m_iter.hasNext()) {
            m_cat = (Category)m_iter.next();
            return true;
        } else {
            return false;
        }
    }

    public Object getElement() {
        return m_cat.getName();
    }

    public String getKey() {
        return m_cat.getID().toString();
    }
}
