/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.cms.TextAsset;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertySheet;
import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.bebop.PropertySheetModelBuilder;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.StringTokenizer;

import com.arsdigita.domain.DomainService;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;

import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.toolbox.util.GlobalizationUtil;
import com.arsdigita.mimetypes.MimeType;

import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Component;

// Renders strings as labels
public class TextAssetBodyLabelCellRenderer implements TableCellRenderer {

    public final static String MIME_TYPE_KEY = 
        TextAsset.MIME_TYPE + "." + MimeType.LABEL;

    public Component getComponent(Table table, PageState state, Object value,
                                  boolean isSelected, Object key,
                                  int row, int column) {
        Label label = null;
        if (TextAsset.CONTENT.equals(key) && value instanceof TextAsset) {
            // We have different styles for different mime types
            TextAsset asset = (TextAsset)value;
            String type = asset.getMimeType().getMimeType()
                .toLowerCase();
            if (type.indexOf("text/xml") > -1 || 
                type.indexOf("text/xsl") > -1 ||
                type.indexOf("text/x-jsp") > -1) {
                label = new Label(asset.getText());
                label.setClassAttr("preformatted");
                label.setOutputEscaping(true);
            } else {
                label = new Label(asset.getText());
                label.setOutputEscaping(false);
            }
        } else if (MIME_TYPE_KEY.equals(key) && value instanceof TextAsset) {
            label = new Label(((TextAsset)value).getMimeType().getLabel(),
                              false);
        } else {
            label = new Label(value.toString());
            label.setOutputEscaping(false);
        }

        return label;
    }
}
