/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.util.LanguageUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Pair;

import java.util.Collection;
import java.util.Iterator;


/**
 * Language picker for the multilingual content items.
 */
public class LanguageWidget extends SingleSelect {

    public LanguageWidget(String name) {
        this(new StringParameter(name));
    }
    
    public LanguageWidget(ParameterModel model) {
        super(model);
        setupOptions();
    }
    
    /**
     * Adds list of languages.
     * Default version shows all supported languages for this CMS installation, as defined
     * in the enterprise.init: com.arsdigita.cms.installer.Initializer: languages
     */
    protected void setupOptions() {
        Collection languages = LanguageUtil.convertToG11N(LanguageUtil.getSupportedLanguages2LA());
        for (Iterator iter=languages.iterator(); iter.hasNext(); ) {
            Pair pair = (Pair) iter.next();
            String langCode = (String) pair.getKey();
            GlobalizedMessage langName = (GlobalizedMessage) pair.getValue();
            addOption(new Option(langCode, new Label(langName)));
        }
    }
    
}
