/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;


import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.util.GlobalizationUtil;

/**
 * A form which edits the width/height/caption of the image.
 * Displays appropriate textboxes.
 *
 * @author Stanislav Freidin (stas@arsdigita.com)
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ImagePropertiesForm extends BasicImageForm {

    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String CAPTION = "caption";

    public ImagePropertiesForm(ItemSelectionModel itemModel,
                               ItemSelectionModel assetModel) {
        super("ImagePropertiesForm", itemModel, assetModel);
    }

    // Add the basic widgeys
    public void addWidgets() {
        super.addWidgets();
    }

    // Init: load the asset and preset fields
    public void init(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Article item = this.getArticle(state);
        ImageAsset asset = this.getImageAsset(state);

        if ( asset == null ) {
            throw new FormProcessException( (String) GlobalizationUtil.globalize("cms.ui.authoring.no_asset").localize());
        }

        initCaption(e);
    }

    // Process: save the data
    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Article item = this.getArticle(state);
        ImageAsset asset = this.getImageAsset(state);

        if ( asset == null ) {
            throw new FormProcessException( (String) GlobalizationUtil.globalize("cms.ui.authoring.no_asset").localize());
        }

        processCaption(e);
        item.save();
    }

}
