/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.util.Assert;

/**
 * Form to search for parties to be added to a staff group.
 *
 * @author Scott Seago &lt;sseago@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/PartySearchForm.java#9 $
 */
public class PartySearchForm extends BaseForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/PartySearchForm.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final static String SEARCH_LABEL = "Search";

    private final TextField m_search;

    public PartySearchForm() {
        super("SearchParties", gz("cms.ui.search"));

        addComponent(new Label(gz("cms.ui.search_prompt")));

        m_search = new TextField(new StringParameter("query"));
        m_search.setSize(40);
        addComponent(m_search);

        addAction(new Submit("finish", gz("cms.ui.search")));
        addAction(new Cancel());

    }

    public final void register(final Page page) {
        super.register(page);

        Assert.assertTrue(page.stateContains(this));
    }

    public TextField getSearchWidget() {
        return m_search;
    }
}
