/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;

/**
 * A navigation bar. Unlike a tabbed dialog, the navbar is completely
 * static. All of its links lead to other pages.
 */
public class Navbar extends BoxPanel {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/Navbar.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String currentLabel;

    /**
     * Construct a new, empty navbar
     *
     * @param currentLabel The currently selected label. The label will
     *   appear in bold.
     */
    public Navbar(String currentLabel) {
        super(HORIZONTAL);
        setBorder(0);

        this.currentLabel = currentLabel;
    }

    /**
     * Construct a new, empty navbar
     *
     */
    public Navbar() {
        this(null);
    }

    /**
     * Add a label to the navbar
     *
     * @param label The string label
     * @param url The URL of the link where the label will link to
     *
     */
    public void add(String label, String url) {

        if(size() > 0) {
            add(new Label(" | "));
        }

        if(label != null && label.equalsIgnoreCase(currentLabel)) {
            Label boldLabel = new Label(label);
            boldLabel.setFontWeight(Label.BOLD);
            add(boldLabel);
        } else {
            add(new com.arsdigita.bebop.Link(label, url));
        }
    }

    /**
     * @return The currently selected label
     */
    public String getCurrentLabel() { return currentLabel; }
}
