/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;

import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ui.QueryGenerator;

/**
 * A wrapper around the {@link ItemSearchSection} which embedds
 * the form section in a form.
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearch.java#14 $
 */
public class ItemSearch extends Form 
    implements Resettable, QueryGenerator {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearch.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final org.apache.log4j.Logger s_log = 
        org.apache.log4j.Logger.getLogger(ItemSearch.class);

    public static final String SINGLE_TYPE_PARAM
        = ItemSearchSection.SINGLE_TYPE_PARAM;

    private ItemSearchSection m_section;

    /**
     * Construct a new <code>ItemSearch</code> component
     *
     * @param context the context for the retrieved items. Should be
     *   {@link ContentItem#DRAFT} or {@link ContentItem#LIVE}
     */
    public ItemSearch(String context) {
        super("itemSearch",new SimpleContainer());
        setMethod("GET");
        m_section = createSearchSection(context);
        add(m_section);
    }

    protected ItemSearchSection createSearchSection(String context) {
        return new ItemSearchSection(context);
    }

    public boolean hasQuery(PageState state) {
        return m_section.hasQuery(state);
    }

    public QuerySpecification getQuerySpecification(PageState state) {
        return m_section.getQuerySpecification(state);
    }

    public void reset(PageState state) {
        m_section.reset(state);
    }
}
