/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemCollection;

/**
 *  A {@link ListModel} that iterates over the passed in ItemCollection
 *  This is an easy starting place for lists that need to dispaly items.
 */
public class ItemListModel implements ListModel {
    
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemListModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    
    private ItemCollection m_collection;
    private ContentItem m_item;

    /**
     * Construct a new <code>GroupListModel</code>
     */
    public ItemListModel(ItemCollection collection) {
        m_collection = collection;
    }

    public boolean next() {
        if(m_collection.next()) {
            m_item = m_collection.getContentItem();
            return true;
        } else {
            m_item = null;
            return false;
        }
    }

    /**
     *  This returns the Name of the item
     */
    public Object getElement() {
        return m_item.getName();
    }

    /**
     *  This returns the item ID as a String
     */
    public String getKey() {
        return m_item.getID().toString();
    }

    /**
     *  This provides protected access to the current content item 
     *  This can be used by code that needs to override the behavior
     *  of getKey or getElement
     */
    protected ContentItem getCurrentItem() {
        return m_item;
    }
}
