/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.cms.ImageAsset;

/**
 * The <code>ImageBrowserModel</code> is an abstraction used by the
 * {@link ImageBrowser} class in order to display a table of images.
 */

public interface ImageBrowserModel {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ImageBrowserModel.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Advance to the next row, if possible
     *
     * @return true if the current row is valid; false if there
     *  are no more rows
     */
    boolean nextRow();

    /**
     * @return the current image asset
     */
    ImageAsset getImageAsset();

    /**
     * @return the label for the action link
     */
    public String getActionLabel();

}
