/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.xml.Element;


/**
 * A solid, horizontal line.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 * @deprecated with no replacement
 */
// FIXME: Could this be done solely in XSL ? Or do some of these attributes
// come from the DB/user preferences ? It would be cleaner if we could move
// this completely to XSL.
public class HorizontalLine extends SimpleComponent {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/HorizontalLine.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String CMS_XML_NS = "http://www.arsdigita.com/cms/1.0";

    private String m_width;
    private String m_height;
    private String m_bgcolor;



    public HorizontalLine() {
        super();
    }

    public String getWidth() {
        return m_width;
    }

    // TODO: should be renamed to setHeight() to make the correspondance
    // with XML more obvious
    public String getThickness() {
        return m_height;
    }

    public String getColor() {
        return m_bgcolor;
    }

    public void setWidth(String w) {
        m_width = w;
    }

    public void setThickness(String t) {
        m_height = t;
    }

    public void setColor(String c) {
        m_bgcolor = c;
    }

    // TODO: document the XML generated by this component
    public void generateXML(PageState state, Element parent) {
        if ( !isVisible(state) ) {
            return;
        }

        Element line = parent.newChildElement("cms:solidLine", CMS_XML_NS);
        line.addAttribute("width", m_width);
        line.addAttribute("height", m_height);
        line.addAttribute("bgcolor", m_bgcolor);
        exportAttributes(line);
    }


}
