/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Link;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.security.Initializer;

/**
 * Delimited dimensional navbar.
 *
 * @author David Lutterkort &lt;dlutter@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/GlobalNavbar.java#8 $
 */
public class GlobalNavbar extends DimensionalNavbar {
    public static final String versionId = 
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/GlobalNavbar.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public GlobalNavbar() {
        super();
        setIdAttr("global-navbar");
        setDelimiter(" - ");
        // FIXME: Write online help, for the time being offer no link
        // add(new Link("Help", "help"));

        String signOutURL = Utilities.getWebappContext() + "/" +
            Initializer.getURL(Initializer.LOGOUT_PAGE_KEY);

        add(new Link((String) globalize("cms.ui.sign_out").localize(),
                     signOutURL));
    }

    /**
     * Getting the GlobalizedMessage using a CMS Class targetBundle.
     *
     * @param key The resource key
     * @pre ( key != null )
     */
    private static GlobalizedMessage globalize(String key) {
        return ContentSectionPage.globalize(key);
    }

}
