/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.cms.dispatcher.Utilities;


/**
 * Creates a {@link ToggleLink} with a button-looking image
 * as a child
 */
public class ControlButton extends ControlLink {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ControlButton.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * The URL of an "Edit" button
     */
    public static final String EDIT = "admin/button/edit.gif";

    /**
     * The URL of an "Add" button
     */
    public static final String ADD = "admin/button/add.gif";

    /**
     * The URL of an "Add Subcategory" button
     */
    public static final String ADD_SUBCATEGORY = "admin/button/add-subcategory.gif";

    /**
     * The URL of a "Delete" button
     */
    public static final String DELETE = "admin/button/delete.gif";


    /**
     * Construct a new ControlButton
     *
     * @param url The URL to the button's image
     */
    public ControlButton(String url) {
        super(new Image(Utilities.getGlobalAssetsURL() + url));
        Image img = (Image)super.getChild();
        img.setBorder("0");
    }

    /**
     * Construct a new ControlButton
     *
     * @param url The URL to the button's image
     * @param l an {@link ActionListener} that will
     */
    public ControlButton(String url, ActionListener l) {
        this(url);
        addActionListener(l);
    }

    // make sure the button responds to events
    public void setControlEvent(PageState s) {
        s.setControlEvent(this);
    }
}
