/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.TreeExpansionEvent;
import com.arsdigita.bebop.event.TreeExpansionListener;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import org.apache.log4j.Logger;

/**
 * A convenience class for CMS trees.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/BaseTree.java#5 $
 */
public class BaseTree extends Tree {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/BaseTree.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(BaseTree.class);

    public BaseTree(final TreeModelBuilder builder) {
        super(builder);

        addChangeListener(new Change());
        addTreeExpansionListener(new TreeExpansion());
    }

    private class Change implements ChangeListener {
        public final void stateChanged(final ChangeEvent e) {
            final PageState state = e.getPageState();
            final Object key = BaseTree.this.getSelectedKey(state);

            if (key != null) {
                expand(key.toString(), state);
            }
        }
    }

    private class TreeExpansion implements TreeExpansionListener {
        public final void treeExpanded(final TreeExpansionEvent e) {
            //s_log.error("expanded");
        }

        public final void treeCollapsed(final TreeExpansionEvent e) {
            //s_log.error("collapsed");
        }
    }
}
