/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.search;


import com.arsdigita.search.ContentType;
import com.arsdigita.search.ContentProvider;


public class ContentPageRawContentProvider implements ContentProvider {

    private byte[] m_content;
    private String m_context;

    public ContentPageRawContentProvider(String context,
                                         byte[] content) {
        m_context = context;
        m_content = content;
    }

    public String getContext() {
        return m_context;
    }

    public ContentType getType() {
        return ContentType.RAW;
    }

    public byte[] getBytes() {
        return m_content;
    }

}
