/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.publishToFile;

/**
 * The listener that does the actual work of writing and removing
 * files. The {@link QueueManager queue manager} calls the listener during
 * queue processing and notifies it of all the tasks that have been
 * queued. The package documentation describes how to set the concrete
 * listener to use.
 *
 * <p> The queue manager processes queue entries in blocks, following these
 * steps:
 * <pre>
 *   Iterator block = get block of queue entries from DB;
 *   start DB transaction
 *   listener.transactionStart();
 *   while (block.hasNext()) {
 *     listener.doTask(block.next());
 *   }
 *   listener.transactionEnd();
 *   commit DB transaction
 * </pre>
 * If the call to {@link #doTask doTask} throws an exception, the entry is
 * marked as failing in the queue and the next entry is processed. If the
 * call to {@link #transactionStart} or {@link #transactionEnd} causes an
 * exception, the whole transaction is rolled back.
 *
 * @see com.arsdigita.cms.publishToFile Configuration information
 * @author Jeff Teeters (teeters@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */


public interface PublishToFileListener {
  
  /**
   * Process one queued task.
   * @param qe  QueueEntry describing the task that should be performed
   */
  public boolean doTask(QueueEntry qe);

  /**
   * Queue manager just started the processing of a new block.
   */
  public void transactionStart();

  /**
   * Queue manager finished processing one block and is about to commit the
   * transaction.
   */
  public void transactionEnd();

}
