/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.portlet;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.ui.portlet.TaskPortletRenderer;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.Portlet;

/**
 * A portlet that displays a list of user tasks. This portlet
 * displays the creation date and title of each listed task.
 *
 * Author: Jim Parsons
 */
public class TaskPortlet extends Portlet {


    public static final String BASE_DATA_OBJECT_TYPE = 
        "com.arsdigita.cms.portlet.TaskPortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public TaskPortlet(DataObject dataObject) {
        super(dataObject);
    }
    
    public int getMaxNumTasks() {
        return ((Integer)get("numTasks")).intValue();
    }

    public void setMaxNumTasks(int taskCount) {
        set("numTasks", new Integer(taskCount));
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new TaskPortletRenderer(this);
    }

}
