/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.portlet;

import com.arsdigita.util.SimpleDataQuery;

import java.math.BigDecimal;


public class ContentSectionsQuery extends SimpleDataQuery {
    
    public static final String QUERY_NAME 
	= "com.arsdigita.london.portal.portlet.getContentSections";

    public static final String URL = "URL";
    public static final String NAME = "name";
    public static final String SECTION_ID = "sectionID";

    public ContentSectionsQuery() {
	super(QUERY_NAME);
    }

    public String getURL() {
	return (String)get(URL);
    }

    public String getName() {
	return (String)get(NAME);
    }
    
    public BigDecimal getSectionID() {
	return (BigDecimal)get(SECTION_ID);
    }
}
