/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;

/**
 * This class contains a collection for Phases
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 *
 * @see DomainCollection
 * @see DataCollection
 **/
public class PhaseCollection extends DomainCollection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/PhaseCollection.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     */
    public PhaseCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Set the order of this Collection. This method needs to be called
     * before <code>next()</code> is called on this collection.
     *
     */
    public void addOrder(String order) {
        m_dataCollection.addOrder(order);
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     */
    public DomainObject getDomainObject() {
        return new Phase(m_dataCollection.getDataObject());
    }

    /**
     * Returns a <code>ContentItem</code> for the current position in
     * the collection.
     */
    public Phase getPhase() {
        return (Phase) getDomainObject();
    }
}
