/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

/**
 * This class registers the action to perform with a lifecycle/phase begins
 * or ends.  Typically, this class is associated with a Lifecycle or Phase
 * DomainObject.
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */


public interface LifecycleListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/LifecycleListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Invoked when an lifecycle or phase begins.  If any runtime exception is
     * thrown, the transaction will be aborted.
     */
    public void begin(LifecycleEvent e);

    /**
     * Invoked when an lifecycle or phase ends.  If any runtime exception is
     * thrown, the transaction will be aborted.
     */
    public void end(LifecycleEvent e);
}
