/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import org.apache.log4j.Logger;

/**
 * Initializes the scheduler thread to fire all the events for the
 * lifecycles or phases that have just began or ended.
 *
 * Where the initializer is registered, you need to include the
 * delay and frequency in seconds
 *
 * @author Jack Chung
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */

public class Initializer
    implements com.arsdigita.initializer.Initializer {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/Initializer.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log =
        Logger.getLogger(Initializer.class);

    private Configuration m_conf = new Configuration();

    private Scheduler scheduler;

    public Initializer() throws InitializationException {
        m_conf.initParameter("delay",
                             "The delay of the scheduler in seconds",
                             Integer.class);
        m_conf.initParameter("frequency",
                             "The frequency of the scheduler in seconds",
                             Integer.class);
    }

    /**
     * Returns the configuration object used by this initializer.
     **/
    public Configuration getConfiguration() {
        return m_conf;
    }


    /**
     * Called on startup.
     **/
    public void startup() {

        Integer delay = (Integer) m_conf.getParameter("delay");
        Integer frequency = (Integer) m_conf.getParameter("frequency");

        Scheduler.s_timerDelay = delay.longValue() * (long) 1000;
        Scheduler.s_timerFrequency = frequency.longValue() * (long) 1000;
        Scheduler.startTimer();
    }

    /**
     * Called on shutdown. It's probably not a good idea to depend on this
     * being called.
     **/
    public void shutdown() {
        Scheduler.stopTimer();
    }

}
