/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.util.Assert;

/**
 * Utility methods for lifecycle durations.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 */
public class Duration {

    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/Duration.java#10 $" +
        " by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * A convenience wrapper around {@link #formatDuration(int)}.
     *
     * @see #formatDuration(int)
     * @pre minutes != null
     */
    public static String formatDuration(Integer minutes) {
        Assert.assertNotNull(minutes, "minutes");
        return formatDuration(minutes.intValue());
    }

    /**
     * Formats a duration into a user friendly format of the form "x days, h
     * hours, m minutes".
     *
     * @param minutes the duration in minutes
     */
    public static String formatDuration(int minutes) {
        int[] dhm = formatDHM(minutes);
        StringBuffer buffer = new StringBuffer();

        if ( dhm[0] > 0 ) {
            buffer.append(dhm[0]).append(" days");
        }

        if ( dhm[1] > 0 ) {
            if ( dhm[0] > 0 ) {
                buffer.append(", ");
            }
            buffer.append(dhm[1]).append(" hours");
        }

        if ( dhm[0] > 0 || dhm[1] > 0 ) {
            buffer.append(", ");
        }
        buffer.append(dhm[2]).append(" minutes");

        return buffer.toString();
    }

    /**
     * Formats time in minutes into a days/hours/minutes format.
     **/
    public static int[] formatDHM(int minutes) {
        int[] dhm = new int[3];

        int days = minutes / (60*24);
        int hours = minutes / 60;  // no pun intended
        int mins = minutes;

        if ( days > 0 ) {
            hours = hours - (days * 24);
            mins = mins - (days * 24 * 60);
        }
        if ( hours > 0 ) {
            mins = mins - (hours * 60);
        }

        dhm[0] = days;
        dhm[1] = hours;
        dhm[2] = mins;
        return dhm;
    }

    /**
     * Formats time in minutes into a days/hours/minutes format.
     *
     * @see #formatDHM(int)
     * @param minutes timespan in minutes
     */
    public static Integer[] formatDHM(Integer minutes) {
        int dhm[] = formatDHM(minutes.intValue());
        return copyArray(dhm);
    }

    private static Integer[] copyArray(int[] from) {
        Assert.assertNotNull(from, "from");
        Integer[] to = new Integer[from.length];
        for (int ii=0; ii<from.length; ii++) {
            to[ii] = new Integer(from[ii]);
        }
        return to;
    }
}
