/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.installer;

import com.arsdigita.initializer.InitializationException;
import org.apache.oro.text.perl.Perl5Util;

/**
 * Utility functions for use by installer classes.
 *
 * @author Jon Orris (jorris@redhat.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */

public class Util {
    public static void validateURLParameter(String name, String value)
        throws InitializationException {

        final String pattern = "/[^A-Za-z_0-9\\-]+/";
        Perl5Util util = new Perl5Util();
        if ( util.match(pattern, value) ) {
            throw new InitializationException
                ("The \"" + name + "\" parameter must contain only " +
                 " alpha-numeric characters, underscores, and/or hyphens.");
        }
    }

}
