/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.installer;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.PackageEventListener;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;



/**
 * <p>Provides methods to install the CMS Service application, which
 * is used by the Content Management System as a store for global
 * resources and assets.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ServiceInstaller implements PackageEventListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/installer/ServiceInstaller.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public final static String PACKAGE_KEY = "cms-service";


    /**
     * Create the CMS services package type.
     * @return The package type
     */
    protected static PackageType createPackageType()
        throws DataObjectNotFoundException {

        PackageType type = PackageType.create
            (PACKAGE_KEY, "Content Management System Services",
             "Content Management System Services",
             "http://cms-service.arsdigita.com/");
        type.setDispatcherClass("com.arsdigita.cms.dispatcher.ServiceDispatcher");
        type.save();

        return type;
    }

    /**
     * Create an instance of the CMS service package type.
     * @return The package instance
     */
    protected static PackageInstance createPackageInstance()
        throws DataObjectNotFoundException {

        PackageType type = PackageType.findByKey(PACKAGE_KEY);
        PackageInstance instance = type.createInstance(PACKAGE_KEY);
        instance.save();

        return instance;
    }

    /**
     * Mount the CMS services package instance.
     *
     * @param instance The package instance
     * @param location The URL where the package instance will be mounted
     * @return The SiteNode where the instance was mounted
     */
    protected static SiteNode mountPackageInstance(PackageInstance instance,
                                                   String location) {
        SiteNode node =
            SiteNode.createSiteNode(location, SiteNode.getRootSiteNode());
        node.mountPackage(instance);
        node.save();

        return node;
    }



    ////////////////////////////////////
    //
    // PackageEventListener methods
    //

    /**
     * This method is called when a package instance is mounted on a
     * siteNode. It does nothing.
     *
     * @param siteNode The SiteNode where the instance is mounted.
     * @param pkg The instance being mounted.
     */
    public void onMount(SiteNode siteNode, PackageInstance pkg) {}

    /**
     * This method is called when a package instance is unmounted from a
     * siteNode. It does nothing.
     *
     * @param siteNode The SiteNode where the instance is mounted.
     * @param pkg The instance being unmounted.
     */
    public void onUnmount(SiteNode siteNode, PackageInstance pkg) {}

    /**
     * This method is called when a new package instance is created.
     * It does nothing
     * @param pkg a <code>PackageInstance</code> value
     */
    public void onCreate(PackageInstance pkg) {}

    /**
     * Describe <code>onDelete</code> method here.
     *
     * @param pkg a <code>PackageInstance</code> value
     */
    public void onDelete(PackageInstance pkg) {}

}
