/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;


/**
 * <p>Generates XML representing a Content Item.</p>
 *
 * <p>As the last step of servicing a page, the
 * {@link com.arsdigita.cms.dispatcher.MasterPage} will go through the
 * hierarchy of its components and ask each of them to convert themselves
 * to XML. A MasterPage contains a special component that knows how to ask
 * its content section for the XML generator that should be applied. The
 * XML generator's <code>generateXML</code> method in turn asks the
 * containing page for the content item, the one that the
 * {@link com.arsdigita.cms.dispatcher.ItemResolver} found before, and
 * formats it as an XML document.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */
public interface XMLGenerator {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/XMLGenerator.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Generates the XML to render the content panel.
     *
     * @param state      The page state
     * @param parent     The parent DOM element
     * @param useContext The use context
     */
    public void generateXML(PageState state, Element parent, String useContext);

}
