/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Template;

import javax.servlet.http.HttpServletRequest;

/**
 * Reimplementation, based on ItemTemplateResolver
 *
 * <p>Many sites offer alternative views of the same content item
 * depending on device or browser, or on user preference.  For
 * example, a site may have "plain" and "fancy" versions of its pages.
 * The fancy versions would be the defaults, while the plain versions
 * would be appropriate for users with low-bandwidth connections,
 * older browsers, or a distaste for flashy appurtenances.  In this
 * the case the selection might be made based on a cookie.</p>
 *
 * <p>Another common example is the "printable" version of a page.
 * In this case a query variable might be more appropriate.</p>
 *
 *
 * @author Karl Goldstein (karlg@arsdigita.com)
 * @version $Revision: #9 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public interface TemplateResolver {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/TemplateResolver.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Returns the JSP template filename relative to the webapp
     * root.
     *
     * @param section The ContentSection for the request
     * @param item The ContentItem for the request
     * @param request The current HttpServletRequest
     *
     * @return The path to the jsp template.
     */
    public String getTemplate(ContentSection section,
                              ContentItem item,
                              HttpServletRequest request);

    /**
     * Returns the JSP template filename relative to the webapp
     * root for a given Template reference.
     *
     * @param template The Template to resolve the URL for.
     *
     * @return The path to the jsp template.
     */
    public String getTemplatePath(Template template);

    /**
     * Returns the XSL template filename relative to the webapp
     * root for a given Template reference.
     *
     * @param template The Template to resolve the URL for.
     *
     * @return The path to the xsl template.
     */
    public String getTemplateXSLPath(Template template);
    
	/**
	     * Sets the TemplateContext parameter in the request
	     * @param sTemplateContext the template context to set
	     * @param request the request in which to set the template context
	     */
	public void setTemplateContext(String sTemplateContext, HttpServletRequest request);
    
    /**
     * Gets the template context from the request.  
     * @param request the request from which to get the template context
     * 
     * @return the template context
     */
    public String getTemplateContext(HttpServletRequest request);	

}
