/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

/**
 * <p>An interface for caching objects.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */
public interface Cache {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/Cache.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Lookup and fetch a cached object.
     *
     * @param key The object key
     * @return The cached object, null if there is none
     */
    public Object get(Object key);

    /**
     * Caches one object.
     *
     * @param key The object key
     * @param value The object to be cached
     * @return The cached object
     */
    public Object put(Object key, Object value);

    /**
     * Removes one cached object.
     *
     * @param key The object key
     * @return The formerly-cached object
     */
    public Object remove(Object key);

    /**
     * Clears the cache.
     */
    public void flush();

}
