/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.xml.Element;

import java.math.BigDecimal;


/**
 * Displays a single ImageAsset, showing its image, width, height,
 * name and mime-type. If the ImageAsset in the selection model is null,
 * be nice about it.
 *
 * @author Hugh Brock (hbrock@redhat.com)
 */
public class ImageDisplay extends SimpleComponent {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/contenttypes/ui/ImageDisplay.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final ItemSelectionModel m_item;

    /**
     * Construct a new ImageDisplay
     *
     * @param m The {@link ItemSelectionModel} which will supply
     *   this component with the {@link ImageAsset}
     */
    public ImageDisplay(ItemSelectionModel m) {
        super();

        m_item = m;
    }

    /**
     * @return the {@link ItemSelectionModel} which supplies this
     *   component with the {@link ImageAsset}
     */
    public final ItemSelectionModel getImageSelectionModel() {
        return m_item;
    }

    public void generateXML(PageState state, Element parent) {
        if ( isVisible(state) ) {

            ImageAsset image = getImageAsset(state);

            if (image != null) {
                Element element = new Element("cms:imageDisplay", CMS.CMS_XML_NS);

                generateImagePropertiesXML(image, state, element);

                exportAttributes(element);
                parent.addContent(element);
            }
        }
    }

    protected void generateImagePropertiesXML(ImageAsset image,
                                              PageState state,
                                              Element element) {
        element.addAttribute("name", image.getName());
        element.addAttribute("src", Utilities.getImageURL(image));

        BigDecimal width = image.getWidth();
        if ( width != null ) {
            element.addAttribute("width", width.toString());
        }

        BigDecimal height = image.getHeight();
        if ( height != null ) {
            element.addAttribute("height", height.toString());
        }

        MimeType mimeType = image.getMimeType();
        if ( mimeType != null ) {
            element.addAttribute("mime_type", mimeType.getLabel());
        }
    }

    protected ImageAsset getImageAsset(PageState state) {
        ImageAsset image = (ImageAsset) m_item.getSelectedObject(state);
        return image;
    }

}
