/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.LegacyInitEvent;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.xml.XML;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.ContentPageMetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.util.StringUtils;
import org.apache.log4j.Logger;


public abstract class ContentTypeInitializer extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger(ContentTypeInitializer.class);
    private final String m_objectType;
    public static final String[] EMPTY_ARRAY = new String[0];

    protected ContentTypeInitializer(final String manifestFile,
                                  final String objectType) {
        final String url = RuntimeConfig.getConfig().getJDBCURL();
        final int database = DbHelper.getDatabaseFromURL(url);


        add(new PDLInitializer
            (new ManifestSource
             (manifestFile,
              new NameFilter(DbHelper.getDatabaseSuffix(database), "pdl"))));

        m_objectType = objectType;
    }

    public void init(LegacyInitEvent evt) {
        super.init(evt);

        final String traversal = getTraversalXML();
        if (!StringUtils.emptyString(traversal)) {
            XML.parseResource
                (traversal,
                 new TraversalHandler());
        }

        try {

            ContentType type = ContentType.findByAssociatedObjectType(m_objectType);

            MetadataProviderRegistry.registerAdapter(
                m_objectType,
                new ContentPageMetadataProvider());

            final String[] stylesheets = getStylesheets();
            for (int i = 0; i < stylesheets.length; i++) {
                String stylesheet = stylesheets[i];
                ContentType.registerXSLFile(type, stylesheet);

            }
        } catch (com.arsdigita.domain.DataObjectNotFoundException e) {
            s_log.debug("Unable to register the stylesheet for " +
                        m_objectType +
                        " because the content type was not found. " + 
                        "This is normal during the load script but " +
                        "should not appear during server startup.");
        }

    }

    public String getTraversalXML() {
        return "";
    }

    public String[] getStylesheets() {
        return EMPTY_ARRAY;
    }
}
