/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;


/**
 * An object that contains a ContentGroup.  Provides 
 * a method for retrieving a ContentGroup based on its
 * attribute name.
 *
 * @author <a href="mailto:mikeb@redhat.com">Mike Bonnet</a>
 **/
public interface ContentGroupContainer {
    
    /**
     * Retrieve a ContentGroup.
     *
     * @param attrName The attribute name of the ContentGroup
     *                 to return.
     * @pre attrName != null
     * @return The specified ContentGroup or null if it
     *         does not exist.
     **/
    ContentGroup getContentGroup(String attrName);

    /**
     * Set a ContentGroup attribute.
     *
     * @param attrName The name of the attribute to set.
     * @param group The ContentGroup to set the attribute to.
     * @pre attrName != null
     **/
    void setContentGroup(String attrName, ContentGroup group);
}
