/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.initializer.Initializer;
import com.arsdigita.persistence.*;
import com.arsdigita.persistence.metadata.*;
import com.arsdigita.runtime.*;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/TroikaRickshawUpgrade.java#5 $
 */
public class TroikaRickshawUpgrade {
    private static final Logger s_log = Logger.getLogger
        (TroikaRickshawUpgrade.class);

    private static final String s_key = "ccm-cms";

    public static final void main(final String[] args) throws IOException {
        new Startup().run();

        final Session session = SessionManager.getSession();

        final TransactionContext tc = session.getTransactionContext();
        tc.beginTxn();

        final ObjectType type = session.getMetadataRoot().getObjectType
            ("com.arsdigita.cms.AuthoringStep");
        final DataCollection coll = session.retrieve(type);

        while (coll.next()) {
            final DataObject data = coll.getDataObject();
            final String component = (String) data.get("component");

            if (component != null && component.equals
                   ("com.arsdigita.cms.contenttypes.ui.FileAttachmentsStep")) {
                data.set
                    ("component",
                     "com.arsdigita.cms.contentassets.ui.FileAttachmentsStep");
            }
        }

        session.flushAll();

        tc.commitTxn();
    }
}
