/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;

/**
 * This class contains a collection of {@link CategoryTemplateMapping}s
 *
 * @version $Id: //cms/dev/src/com/arsdigita/cms/CategoryTemplateCollection.java#7 $
 *
 * @see DomainCollection
 * @see DataCollection
 * @see ItemTemplateCollection
 */
public class CategoryTemplateCollection extends TemplateCollection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/CategoryTemplateCollection.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

  /** 
   * Constructor.
   *
   * @see com.arsdigita.cms.TemplateCollection
   **/
  public CategoryTemplateCollection(DataCollection dataCollection) {
    super(dataCollection);
  }
  
  /**
   * Returns a <code>DomainObject</code> for the current position in
   * the collection.
   *
   */
  public DomainObject getDomainObject() {
    return new CategoryTemplateMapping(m_dataCollection.getDataObject());
  }

  /**
   * Return the current template
   */
  public Template getTemplate() {
    CategoryTemplateMapping m = (CategoryTemplateMapping)getDomainObject();
    if(m == null) return null;
    return m.getTemplate();
  }

  /**
   * Return the current use context
   */
  public String getUseContext() {
    CategoryTemplateMapping m = (CategoryTemplateMapping)getDomainObject();
    if(m == null) return null;
    return m.getUseContext();
  }

  /**
   * Return true if the current template is the default for its context
   */
  public Boolean isDefault() {
    CategoryTemplateMapping m = (CategoryTemplateMapping)getDomainObject();
    if(m == null) return null;
    return m.isDefault();
  }

}
