/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;

/**
 * This class contains contains a collection of
 * ArticleImageAssociations, each of which points to an image, and
 * each of which has a caption. Ideally it should be constructed with
 * a DataCollection of ArticleImageAssociations which has been
 * filtered on isDeleted=0, or there will be deleted associations in
 * the collection. It extends ImageAssetCollection because we need to
 * pass it off as an ImageAssetCollection at various places in the UI
 * code.
 *
 * @author Hugh Brock .
 *
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 */
public class ArticleImageAssnCollection extends ImageAssetCollection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ArticleImageAssnCollection.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor. Should only be called from Article.getImages()
     *
     **/
    protected ArticleImageAssnCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns a <code>DomainObject</code> (the
     * ArticleImageAssociation for the current position in the
     * collection.
     *
     **/
    public DomainObject getDomainObject() {
	return new ArticleImageAssociation
	    (m_dataCollection.getDataObject());
    }

    /**
     * Returns a <code>Image</code> for the current position in
     * the collection.
     *
     **/
    public ImageAsset getImage() {
        return ((ArticleImageAssociation)getDomainObject()).getImage();
    }

    public String getCaption() {
	return ((ArticleImageAssociation)getDomainObject()).getCaption();
    }

    // Exposed methods
    public Filter addEqualsFilter(String attribute, Object value) {
	return m_dataCollection.addEqualsFilter(attribute, value);
    }


}
