--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/oracle-se/upgrade/5.2.1-6.0.0/cms_category_template_map.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

create table cms_category_template_map (
    mapping_id INTEGER not null
        constraint cms_cat_tem_map_map_id_p_iq1jy
          primary key,
        -- referential constraint for mapping_id deferred due to circular dependencies
    category_id INTEGER not null,
        -- referential constraint for category_id deferred due to circular dependencies
    type_id INTEGER not null,
        -- referential constraint for type_id deferred due to circular dependencies
    section_id INTEGER not null,
        -- referential constraint for section_id deferred due to circular dependencies
    template_id INTEGER not null,
        -- referential constraint for template_id deferred due to circular dependencies
    use_context VARCHAR(200) not null,
    is_default CHAR(1) not null
);

alter table cms_category_template_map add
    constraint cms_cat_tem_map_cat_id_f_fa56u foreign key (category_id)
      references cat_categories(category_id);
alter table cms_category_template_map add
    constraint cms_cat_tem_map_map_id_f_8eq3y foreign key (mapping_id)
      references acs_objects(object_id);
alter table cms_category_template_map add
    constraint cms_cat_tem_map_sec_id_f_3p3qy foreign key (section_id)
      references content_sections(section_id);
alter table cms_category_template_map add
    constraint cms_cat_tem_map_tem_id_f_rdnza foreign key (template_id)
      references cms_templates(template_id);
alter table cms_category_template_map add
    constraint cms_cat_tem_map_typ_id_f_ls_qa foreign key (type_id)
      references content_types(type_id);

create unique index cms_ctm_unique on cms_category_template_map
  (category_id, type_id, template_id, use_context);

comment on table cms_category_template_map is '
  Maps (category + type) to templates. Each content type
  within each category can have a different subset of templates.
  This table defines a set of templates which could possibly
  be assigned to content items.
';

comment on column cms_category_template_map.use_context is '
  A string that describes the context in which the template is
  to be used. There can be multiple templates registered to
  a content type in a certain context; for example, a
  public template may be used to display items on the public
  pages, and a summary template may be used to display items
  as search results.
';

comment on column cms_category_template_map.is_default is '
  A boolean value that determines whether the given template
  is the default template for its use context.
';
