--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/postgres/upgrade/5.2.1-6.0.0/update-publish-to-fs.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

-- update the publish_to_file code to new version

\qecho Update Publish-To-Filesystem tables

-- unique constraint
alter table publish_to_fs_files add constraint publish_to_fs_files_un unique(file_name);

-- rename server_id to host_id
alter table publish_to_fs_files rename server_id to host_id;
alter table publish_to_fs_files add
    constraint publi_to_fs_fil_hos_id_f_nwho1 foreign key (host_id)
      references web_hosts(host_id);

-- add item_type column
alter table publish_to_fs_files add item_type VARCHAR(100);

update publish_to_fs_files
   set item_type = (select object_type
                      from acs_objects
                     where object_id = id);

alter table publish_to_fs_files alter item_type set not null;

-- drop unused columns
alter table publish_to_fs_files drop column deleted;
alter table publish_to_fs_files drop column parent_id;

-- publish_to_fs_queue table
--------------------------------------------------------------------------------
-- rename host_id to server_id
alter table publish_to_fs_queue add host_id INTEGER;

update publish_to_fs_queue
   set host_id = server_id;

alter table publish_to_fs_queue alter host_id set not null;

alter table publish_to_fs_queue add
    constraint publi_to_fs_que_hos_id_f_9wfcg foreign key (host_id)
      references web_hosts(host_id);

-- drop unused columns
alter table publish_to_fs_queue drop base_type;
alter table publish_to_fs_queue drop extra_info;
alter table publish_to_fs_queue drop server_id;
alter table publish_to_fs_queue drop source;
alter table publish_to_fs_queue drop task_mode;

-- publish_to_fs_servers table
--------------------------------------------------------------------------------
drop table publish_to_fs_servers;
drop index pub_to_fs_files_server_id_idx;
