--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/table-content_sections.sql#4 $
-- $DateTime: 2004/04/07 16:07:11 $

--bryanche todo: changed section_id fk from acs_objects to sections,
--dropped column package_id

create table content_sections (
  section_id           integer
                       constraint content_sections_pk
                       primary key
                       constraint csections_section_id_fk 
                       references applications(application_id),
  pretty_name          varchar(300) not null
                       constraint csections_name_un
                       unique,
  root_folder_id       integer 
                       constraint csections_root_folder_id_nil
                       not null
                       constraint csections_root_folder_id_fk
                       references cms_folders,
  templates_folder_id  integer 
                       constraint csections_temps_folder_id_fk
                       references cms_folders,
  staff_group_id       integer not null
                       constraint csections_staff_group_id_fk
                       references groups,
  viewers_group_id     integer not null
                       constraint csections_viewers_group_id_fk
                       references groups,
  page_resolver_class  varchar(1000) not null,
  item_resolver_class  varchar(1000) not null,
  template_resolver_class  varchar(1000) not null,
  xml_generator_class  varchar(1000) not null
);
