/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TypeElements
extends BoxPanel {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$type$TypeElements == null ? (class$com$arsdigita$cms$ui$type$TypeElements = TypeElements.class$("com.arsdigita.cms.ui.type.TypeElements")) : class$com$arsdigita$cms$ui$type$TypeElements));
    private SingleSelectionModel m_types;
    private Table m_elementsTable;
    private TableColumn m_removeColumn;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$type$TypeElements;

    public TypeElements(SingleSelectionModel m) {
        this.m_types = m;
        this.m_elementsTable = this.makeElementsTable();
        this.m_removeColumn = this.m_elementsTable.getColumn(3);
        this.m_removeColumn.setCellRenderer((TableCellRenderer)new RemoveCellRenderer());
        this.m_removeColumn.setAlign("center");
        this.m_elementsTable.addTableActionListener((TableActionListener)new ElementRemover());
        this.add((Component)this.m_elementsTable);
    }

    public void register(Page p) {
        p.addComponent((Component)this);
    }

    public Table getTable() {
        return this.m_elementsTable;
    }

    private ContentType makeType(BigDecimal typeId) {
        ContentType type = null;
        try {
            type = new ContentType(typeId);
        }
        catch (DataObjectNotFoundException e) {
            UncheckedWrapperException.throwLoggedException(((Object)((Object)this)).getClass(), (String)("Unable to make content type for id: " + typeId), (Throwable)e);
        }
        return type;
    }

    private DynamicObjectType getDynamicObjectType(PageState s) {
        BigDecimal typeId = new BigDecimal(this.m_types.getSelectedKey(s).toString());
        ContentType type = this.makeType(typeId);
        return new DynamicObjectType(type.getAssociatedObjectType());
    }

    private Table makeElementsTable() {
        Object[] headers = new String[]{"Name", "Element Type", "Multiplicity", "Remove"};
        TableModelBuilder b = new TableModelBuilder((String[])headers){
            private boolean m_locked;
            private final /* synthetic */ String[] val$headers;
            {
                this.val$headers = val$headers;
            }

            public TableModel makeModel(Table t, PageState s) {
                return new TableModel(this, s){
                    DynamicObjectType dot;
                    Iterator declaredProperties;
                    Property currentProperty;
                    private final /* synthetic */ PageState val$s;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$s = val$s;
                        this.dot = TypeElements.access$400(1.access$500(this.this$1), this.val$s);
                        this.declaredProperties = this.dot.getObjectType().getDeclaredProperties();
                        this.currentProperty = null;
                    }

                    public int getColumnCount() {
                        return 1.access$600(this.this$1).length;
                    }

                    public boolean nextRow() {
                        boolean next = this.declaredProperties.hasNext();
                        if (next) {
                            this.currentProperty = (Property)this.declaredProperties.next();
                        }
                        return next;
                    }

                    public Object getElementAt(int columnIndex) {
                        if (this.currentProperty == null) {
                            throw new IllegalArgumentException();
                        }
                        switch (columnIndex) {
                            case 0: {
                                return this.currentProperty.getName();
                            }
                            case 1: {
                                String dataType = this.currentProperty.getType().getName();
                                if (dataType.equals("String")) {
                                    return "text";
                                }
                                if (dataType.equals("BigDecimal")) {
                                    return "number";
                                }
                                if (dataType.equals("Date")) {
                                    return "date";
                                }
                                return dataType;
                            }
                            case 2: {
                                if (this.currentProperty.isNullable()) {
                                    return "0 or 1";
                                }
                                if (this.currentProperty.isRequired()) {
                                    return "1";
                                }
                                if (this.currentProperty.isCollection()) {
                                    return "0 to n";
                                }
                                return new Integer(this.currentProperty.getMultiplicity());
                            }
                            case 3: {
                                return new Boolean(this.isRemovable());
                            }
                        }
                        throw new IllegalArgumentException("columnIndex exceeds number of columns available");
                    }

                    public Object getKeyAt(int columnIndex) {
                        if (this.currentProperty == null) {
                            throw new IllegalArgumentException();
                        }
                        return this.currentProperty.getName();
                    }

                    private boolean isRemovable() {
                        return true;
                    }
                };
            }

            public void lock() {
                this.m_locked = true;
            }

            public boolean isLocked() {
                return this.m_locked;
            }

            static /* synthetic */ TypeElements access$500(1 x0) {
                return x0.TypeElements.this;
            }

            static /* synthetic */ String[] access$600(1 x0) {
                return x0.val$headers;
            }
        };
        Table result = new Table(b, headers);
        CMSContainer ifemptable = new CMSContainer();
        ifemptable.setClassAttr("emptyTypeElementsTable");
        result.setEmptyView((Component)ifemptable);
        result.setClassAttr("ContentTypeElementsTable");
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ElementRemover
    extends TableActionAdapter {
        private ElementRemover() {
        }

        public void cellSelected(TableActionEvent e) {
            int col = e.getColumn();
            if (TypeElements.this.m_removeColumn != TypeElements.this.m_elementsTable.getColumn(col)) {
                return;
            }
            PageState s = e.getPageState();
            DynamicObjectType dot = TypeElements.this.getDynamicObjectType(s);
            String element = e.getRowKey().toString();
            dot.removeAttribute(element);
            dot.save();
        }
    }

    private static class RemoveCellRenderer
    implements TableCellRenderer {
        private static Label s_noAction = new Label("&nbsp;", false);
        private static ControlLink s_link;

        private RemoveCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (((Boolean)value).booleanValue()) {
                return s_link;
            }
            return s_noAction;
        }

        static {
            s_noAction.lock();
            s_link = new ControlLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.element.delete")));
            s_link.setConfirmation("Permanently remove this element?");
        }
    }
}

