/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.type.TypeSecurityListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

public class SelectType
extends CMSForm
implements PrintListener,
FormSubmissionListener,
FormProcessListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/type/SelectType.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String TYPES = "types";
    private CheckboxGroup m_typesCheckbox = new CheckboxGroup("types");
    private Submit m_submit;
    private Submit m_cancel;

    public SelectType() {
        super("ContentTypeSelect");
        try {
            this.m_typesCheckbox.addPrintListener((PrintListener)this);
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners: " + e.getMessage());
        }
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.available_types")));
        this.add((Component)this.m_typesCheckbox);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel("Add Selected Content Types");
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit("cancel");
        this.m_cancel.setButtonLabel("Cancel");
        s.add((Component)this.m_cancel);
        this.add((Component)s, 66);
        this.addProcessListener(this);
        this.addSubmissionListener(new TypeSecurityListener());
        this.addSubmissionListener(this);
    }

    public void prepare(PrintEvent event) {
        CheckboxGroup t = (CheckboxGroup)event.getTarget();
        ContentSection section = CMS.getContext().getContentSection();
        ContentTypeCollection contentTypes = section.getNotAssociatedContentTypes();
        contentTypes.addOrder("label");
        while (contentTypes.next()) {
            ContentType contentType = contentTypes.getContentType();
            t.addOption(new Option(contentType.getID().toString(), contentType.getLabel()));
        }
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.isCancelled(state)) {
            throw new FormProcessException("cancelled");
        }
    }

    public boolean isCancelled(PageState state) {
        return this.m_cancel.isSelected(state);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        ContentSection section = CMS.getContext().getContentSection();
        FormData data = e.getFormData();
        String[] types = (String[])data.get((Object)TYPES);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                try {
                    ContentType type = new ContentType(new BigDecimal(types[i]));
                    section.addContentType(type);
                    continue;
                }
                catch (DataObjectNotFoundException ex) {
                    throw new UncheckedWrapperException("Content Type ID#" + types[i] + " not found", (Throwable)ex);
                }
            }
            if (types.length > 0) {
                section.save();
            }
        }
    }
}

