/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

abstract class TemplatesListing
extends DataTable {
    private TableColumn m_removeCol;
    private ACSObjectSelectionModel m_mappingModel;
    private static final String MAPPING_ID = "mid";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$templates$TemplatesListing == null ? (class$com$arsdigita$cms$ui$templates$TemplatesListing = TemplatesListing.class$("com.arsdigita.cms.ui.templates.TemplatesListing")) : class$com$arsdigita$cms$ui$templates$TemplatesListing));
    static /* synthetic */ Class class$com$arsdigita$cms$ui$templates$TemplatesListing;

    public TemplatesListing(ACSObjectSelectionModel mappingModel) {
        super((DataQueryBuilder)new AbstractQueryBuilder());
        this.addColumn("Context", "useContext", false);
        this.addColumn("Name", "template", false, new TemplateNameCellRenderer());
        this.addColumn("Label", "template.label", false);
        this.addColumn("Mime Type", "template", false, new MimeTypeCellRenderer());
        this.m_mappingModel = mappingModel;
        this.setRowSelectionModel((SingleSelectionModel)this.m_mappingModel);
        this.setEmptyView((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.no_templates")));
    }

    public TemplatesListing() {
        this(new ACSObjectSelectionModel(MAPPING_ID));
    }

    protected abstract TemplateCollection getTemplateCollection(PageState var1);

    protected void removeTemplate(PageState s, TemplateMapping mapping) {
        throw new UnsupportedOperationException((String)GlobalizationUtil.globalize("cms.ui.templates.not_implemented").localize());
    }

    protected final ACSObjectSelectionModel getMappingModel() {
        return this.m_mappingModel;
    }

    public final TableColumn getRemoveColumn() {
        return this.m_removeCol;
    }

    protected final void addRemoveColumn() {
        Assert.assertNotLocked((Lockable)this);
        Assert.assertTrue((this.m_removeCol == null ? 1 : 0) != 0, (String)"The \"remove\" column already exists");
        this.m_removeCol = this.addColumn("Remove", "template", false, new RemoveCellRenderer());
        this.addTableActionListener((TableActionListener)new TableActionAdapter(){

            public void cellSelected(TableActionEvent e) {
                PageState s = e.getPageState();
                TemplatesListing l = (TemplatesListing)((Object)e.getSource());
                int i = e.getColumn();
                TableColumn c = l.getColumnModel().get(i);
                if (TemplatesListing.this.m_removeCol.equals(c)) {
                    TemplatesListing.this.removeTemplate(s, (TemplateMapping)TemplatesListing.this.m_mappingModel.getSelectedObject(s));
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MimeTypeCellRenderer
    implements TableCellRenderer {
        protected MimeTypeCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            MimeType mimeType = null;
            if (value != null) {
                Template item = (Template)DomainObjectFactory.newInstance((DataObject)((DataObject)value));
                mimeType = item.getMimeType();
            } else {
                try {
                    DataObject object = (DataObject)TemplatesListing.this.getDataQuery(state).get("mimeType");
                    if (object != null) {
                        mimeType = (MimeType)DomainObjectFactory.newInstance((DataObject)object);
                    }
                }
                catch (DataObjectNotFoundException donfe) {
                    s_log.debug((Object)("No Mime Type for cell with value of " + value + " and key of " + key), (Throwable)donfe);
                }
            }
            if (mimeType != null) {
                GlobalizedMessage mimeTypeMessage = (GlobalizedMessage)Template.SUPPORTED_MIME_TYPES.get(mimeType.getMimeType());
                if (mimeTypeMessage != null) {
                    return new Label(mimeTypeMessage, false);
                }
                return new Label(mimeType.getLabel(), false);
            }
            return new Label("&nbsp;", false);
        }
    }

    protected static class TemplateNameCellRenderer
    implements TableCellRenderer {
        protected TemplateNameCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label("&nbsp;", false);
            }
            Template item = (Template)DomainObjectFactory.newInstance((DataObject)((DataObject)value));
            ContentSection sec = CMS.getContext().getContentSection();
            ItemResolver res = sec.getItemResolver();
            String url = res.generateItemURL(state, item, sec, "draft");
            return new Link(item.getName(), url);
        }
    }

    private static class RemoveCellRenderer
    implements TableCellRenderer {
        private ControlLink m_link = new ControlLink((String)GlobalizationUtil.globalize("cms.ui.templates.remove").localize());
        private Label m_label = new Label("&nbsp;", false);

        public RemoveCellRenderer() {
            this.m_link.setConfirmation("Are you sure you want to remove this template ?");
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return this.m_label;
            }
            return this.m_link;
        }
    }

    protected static class AbstractQueryBuilder
    extends LockableImpl
    implements DataQueryBuilder {
        public DataQuery makeDataQuery(DataTable t, PageState s) {
            TemplatesListing l = (TemplatesListing)t;
            return l.getTemplateCollection(s).getDataCollection();
        }

        public String getKeyColumn() {
            return "id";
        }
    }
}

