/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ui.SortableList;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

abstract class SortableCategoryList
extends SortableList {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/SortableCategoryList.java#11 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$category$SortableCategoryList == null ? (class$com$arsdigita$cms$ui$category$SortableCategoryList = SortableCategoryList.class$("com.arsdigita.cms.ui.category.SortableCategoryList")) : class$com$arsdigita$cms$ui$category$SortableCategoryList));
    public static final String CHILDREN = "ch";
    private final CategoryRequestLocal m_parent;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$category$SortableCategoryList;

    public SortableCategoryList(CategoryRequestLocal parent) {
        super(new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(CHILDREN)));
        this.m_parent = parent;
        this.setIdAttr("categorized_objects_list");
    }

    protected final Category getCategory(PageState state) {
        return this.m_parent.getCategory(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void respond(PageState ps) throws ServletException {
        String event = ps.getControlEventName();
        if ("next".equals(event) || "prev".equals(event)) {
            try {
                ACSObject child = (ACSObject)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.ACSObject", (Object)new BigDecimal(ps.getControlEventValue())));
                Category parent = this.m_parent.getCategory(ps);
                if (!CMS.getContext().getSecurityManager().canAccess("category_admin")) return;
                if ("next".equals(event)) {
                    parent.swapWithNext(child);
                } else {
                    parent.swapWithPrevious(child);
                }
                parent.save();
                return;
            }
            catch (DataObjectNotFoundException e) {
                s_log.error((Object)("Trying to create categories with state = " + ps), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            super.respond(ps);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

