/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ui.category.CategoryCollectionListModel;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;

public class CategoryLinks
extends List {
    public static final String SUB_CATEGORY = "sc";
    private final CategoryRequestLocal m_parent;
    private final SingleSelectionModel m_model;

    public CategoryLinks(CategoryRequestLocal parent, SingleSelectionModel model) {
        super((SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(SUB_CATEGORY)));
        this.setIdAttr("category_links_list");
        this.m_parent = parent;
        this.m_model = model;
        this.setModelBuilder(new LinkedCategoryModelBuilder());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String id = (String)CategoryLinks.this.getSelectedKey(state);
                if (id != null) {
                    CategoryLinks.this.m_model.setSelectedKey(state, (Object)id);
                }
            }
        });
        Label label = new Label(GlobalizationUtil.globalize("cms.ui.category.linked.none"));
        label.setFontWeight("i");
        this.setEmptyView((Component)label);
    }

    private class LinkedCategoryModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private LinkedCategoryModelBuilder() {
        }

        public ListModel makeModel(List list, PageState state) {
            Category category = CategoryLinks.this.m_parent.getCategory(state);
            if (category != null && !category.isRoot() && category.getParentCategoryCount() > 1L) {
                Category parent = category.getDefaultParentCategory();
                return new CategoryCollectionListModel(category.getParents(), parent == null ? null : parent.getID());
            }
            return List.EMPTY_MODEL;
        }
    }
}

