/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ui.authoring.CategoryWidget;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ItemCategoryForm
extends Form {
    private CategoryWidget m_category;
    private SaveCancelSection m_buttons;

    public ItemCategoryForm(BigDecimalParameter root, StringParameter mode) {
        super("category", (Container)new BoxPanel(2));
        this.m_category = new CategoryWidget("category", root, mode);
        this.m_category.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_buttons = new SaveCancelSection();
        this.add((Component)this.m_category);
        this.add((Component)this.m_buttons);
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) throws FormProcessException {
                PageState state = ev.getPageState();
                ContentItem item = CMS.getContext().getContentItem();
                ContentBundle bundle = (ContentBundle)item.getParent();
                ArrayList<BigDecimal> ids = new ArrayList<BigDecimal>();
                CategoryCollection cats = bundle.getCategoryCollection();
                while (cats.next()) {
                    ids.add(cats.getCategory().getID());
                }
                ItemCategoryForm.this.m_category.setValue(state, ids.toArray(new BigDecimal[ids.size()]));
            }
        });
        this.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) throws FormProcessException {
                PageState state = ev.getPageState();
                ContentItem item = CMS.getContext().getContentItem();
                ContentBundle bundle = (ContentBundle)item.getParent();
                BigDecimal[] ids = (BigDecimal[])ItemCategoryForm.this.m_category.getValue(state);
                for (int i = 0; i < ids.length; ++i) {
                    Category cat = (Category)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.categorization.Category", (Object)ids[i]));
                    cat.addChild((ACSObject)bundle);
                }
                ItemCategoryForm.this.fireCompletionEvent(state);
            }
        });
        this.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent ev) throws FormProcessException {
                PageState state = ev.getPageState();
                if (ItemCategoryForm.this.m_buttons.getCancelButton().isSelected(state)) {
                    ItemCategoryForm.this.fireCompletionEvent(state);
                    throw new FormProcessException("cancelled");
                }
            }
        });
    }
}

