/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.dispatcher.ContentCenterDispatcher;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ItemSearchParameter;
import com.arsdigita.cms.ui.ItemSearchSectionInline;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ItemSearchWidget
extends FormSection
implements BebopConstants,
FormSubmissionListener,
FormInitListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$ItemSearchWidget == null ? (class$com$arsdigita$cms$ui$ItemSearchWidget = ItemSearchWidget.class$("com.arsdigita.cms.ui.ItemSearchWidget")) : class$com$arsdigita$cms$ui$ItemSearchWidget));
    private TextField m_item;
    private Submit m_search;
    private Submit m_clear;
    private Label m_jsLabel;
    private Label m_topHR;
    private Label m_bottomHR;
    private ContentType m_contentType;
    private ItemSearchSectionInline m_searchComponent;
    private String m_name;
    private String m_searchName;
    private String m_clearName;
    private ParameterModel m_model;
    public static final String BEBOP_ITEM_SEARCH = "bebop:itemSearch";
    static /* synthetic */ Class class$com$arsdigita$cms$ui$ItemSearchWidget;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$ItemSearchPage;

    public ItemSearchWidget(ParameterModel model) {
        this(model, null);
    }

    public ItemSearchWidget(ParameterModel model, ContentType contentType) {
        super((Container)new BoxPanel(2));
        if (!(model instanceof ItemSearchParameter)) {
            throw new IllegalArgumentException("The ItemSearch widget " + model.getName() + " must be backed by a ItemSearchParameter parmeter model");
        }
        this.m_name = model.getName();
        this.m_searchName = this.m_name + "_search";
        this.m_clearName = this.m_name + "_clear";
        this.m_model = model;
        final String typeURLFrag = contentType != null ? contentType.getID().toString() : null;
        this.m_contentType = contentType;
        this.m_item = new ItemFragment(model, this);
        this.m_search = new SearchFragment(this.m_searchName, this, this.m_contentType);
        this.m_clear = new ClearFragment(this.m_clearName, this);
        this.m_jsLabel = new LabelFragment("", false, this);
        this.m_jsLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label t = (Label)event.getTarget();
                String formName = ((LabelFragment)t).parent.getSearchButton().getForm().getName();
                ParameterMap params = new ParameterMap();
                params.setParameter("section_id", (Object)CMS.getContext().getContentSection().getID());
                params.setParameter("widget", formName + ".elements['" + ItemSearchWidget.this.m_item.getName() + "']");
                if (typeURLFrag != null) {
                    params.setParameter("single_type", typeURLFrag);
                }
                String searchURL = ContentCenterDispatcher.getURLStubForClass((class$com$arsdigita$cms$ui$ItemSearchPage == null ? (class$com$arsdigita$cms$ui$ItemSearchPage = ItemSearchWidget.class$("com.arsdigita.cms.ui.ItemSearchPage")) : class$com$arsdigita$cms$ui$ItemSearchPage).getName());
                s_log.debug((Object)("Search URL stub is: " + searchURL));
                searchURL = Utilities.getWorkspaceURL() + searchURL;
                URL url = URL.there((HttpServletRequest)state.getRequest(), (String)searchURL, (ParameterMap)params);
                t.setLabel(" <script language=javascript>  <!-- \n function " + ItemSearchWidget.this.m_item.getName().replace('.', '_') + "Popup(theForm) { \n" + " aWindow = window.open(\"" + url + "\", \"search\", \"toolbar=no,width=800,height=600,status=no,scrollbars=yes,resize=yes,menubar=no\");\n return false;\n" + " } \n" + " --> \n" + " </script> ");
            }
        });
        this.m_topHR = new HRLabel();
        this.add((Component)this.m_topHR);
        FormSection searchSection = new FormSection((Container)new BoxPanel(1));
        searchSection.add((Component)this.m_item);
        searchSection.add((Component)this.m_search);
        searchSection.add((Component)this.m_clear);
        searchSection.add((Component)this.m_jsLabel);
        this.add((Component)searchSection);
        this.m_searchComponent = new ItemSearchFragment(this.m_name, "draft", this);
        this.add((Component)this.m_searchComponent);
        this.addSubmissionListener(this);
        this.addInitListener(this);
        this.m_bottomHR = new HRLabel();
        this.add((Component)this.m_bottomHR);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_topHR, false);
        p.setVisibleDefault((Component)this.m_searchComponent, false);
        p.setVisibleDefault((Component)this.m_bottomHR, false);
    }

    public ItemSearchWidget(String name) {
        this((ParameterModel)new ItemSearchParameter(name));
    }

    public ItemSearchWidget(String name, String objectType) throws DataObjectNotFoundException {
        this(name, objectType == null || objectType.length() == 0 ? null : ContentType.findByAssociatedObjectType(objectType));
    }

    public ItemSearchWidget(String name, ContentType contentType) {
        this((ParameterModel)new ItemSearchParameter(name, contentType), contentType);
    }

    public Submit getSearchButton() {
        return this.m_search;
    }

    public Submit getClearButton() {
        return this.m_clear;
    }

    public TextField getItemField() {
        return this.m_item;
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        try {
            this.m_searchComponent.setVisible(s, false);
            this.m_topHR.setVisible(s, false);
            this.m_bottomHR.setVisible(s, false);
            this.m_search.setVisible(s, true);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        FormData data = e.getFormData();
        s_log.debug((Object)"Doing submission");
        if (this.m_searchComponent.isItemSelected(s)) {
            s_log.debug((Object)"Item selected");
            ContentItem item = this.m_searchComponent.getSelectedItem(s);
            if (item != null) {
                this.m_item.setValue(s, (Object)item);
            }
            try {
                this.m_searchComponent.setVisible(s, false);
                this.m_topHR.setVisible(s, false);
                this.m_bottomHR.setVisible(s, false);
                this.m_search.setVisible(s, true);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            throw new FormProcessException("item search FormSection submit");
        }
        if (this.m_searchComponent.hasQuery(s)) {
            s_log.debug((Object)"Has query");
            try {
                this.m_searchComponent.setVisible(s, true);
                this.m_searchComponent.processQuery(s);
                this.m_topHR.setVisible(s, true);
                this.m_bottomHR.setVisible(s, true);
                this.m_search.setVisible(s, false);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            if (this.m_contentType != null) {
                s.setValue((ParameterModel)new BigDecimalParameter("single_type"), (Object)this.m_contentType.getID());
            } else {
                s.setValue((ParameterModel)new BigDecimalParameter("single_type"), null);
            }
            throw new FormProcessException("item search FormSection submit");
        }
        if (this.m_search.isSelected(s)) {
            s_log.debug((Object)"Search selected");
            try {
                this.m_searchComponent.setVisible(s, true);
                this.m_searchComponent.processQuery(s);
                this.m_topHR.setVisible(s, true);
                this.m_bottomHR.setVisible(s, true);
                this.m_search.setVisible(s, false);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            if (this.m_contentType != null) {
                s.setValue((ParameterModel)new BigDecimalParameter("single_type"), (Object)this.m_contentType.getID());
            } else {
                s.setValue((ParameterModel)new BigDecimalParameter("single_type"), null);
            }
            throw new FormProcessException("item search FormSection submit");
        }
        if (this.m_clear.isSelected(s)) {
            s_log.debug((Object)"Clear selected");
            this.m_item.setValue(s, null);
            try {
                this.m_searchComponent.setVisible(s, false);
                this.m_topHR.setVisible(s, false);
                this.m_bottomHR.setVisible(s, false);
                this.m_search.setVisible(s, true);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            throw new FormProcessException("item search FormSection submit");
        }
        s_log.debug((Object)"Something else");
        try {
            this.m_searchComponent.setVisible(s, false);
            this.m_topHR.setVisible(s, false);
            this.m_bottomHR.setVisible(s, false);
            this.m_search.setVisible(s, true);
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HRLabel
    extends Label {
        public HRLabel() {
            super("<hr/>", false);
        }

        public boolean isVisible(PageState ps) {
            return (ItemSearchWidget.this.m_search.isSelected(ps) || ItemSearchWidget.this.m_searchComponent.hasQuery(ps)) && super.isVisible(ps);
        }
    }

    private class ItemSearchFragment
    extends ItemSearchSectionInline {
        private ItemSearchWidget parent;

        public ItemSearchFragment(String name, String context, ItemSearchWidget parent) {
            super(name, context);
            this.parent = parent;
        }

        public boolean isVisible(PageState ps) {
            return (ItemSearchWidget.this.m_search.isSelected(ps) || this.hasQuery(ps)) && super.isVisible(ps);
        }
    }

    private class LabelFragment
    extends Label {
        private ItemSearchWidget parent;

        public LabelFragment(String name, boolean escaping, ItemSearchWidget parent) {
            super(name, escaping);
            this.parent = parent;
        }
    }

    private class ClearFragment
    extends Submit {
        private ItemSearchWidget parent;

        public ClearFragment(String name, ItemSearchWidget parent) {
            super(name, "Clear");
            this.avoidDoubleClick(false);
            this.parent = parent;
            this.setAttribute("onClick", "this.form." + parent.m_item.getName() + ".value = \"\"; return false;");
            this.setAttribute("value", "Clear");
        }
    }

    private class SearchFragment
    extends Submit {
        private ItemSearchWidget parent;
        private ContentType contentType;

        public SearchFragment(String name, ItemSearchWidget parent, ContentType contentType) {
            super(name, "Search");
            this.avoidDoubleClick(false);
            this.parent = parent;
            this.contentType = contentType;
            this.setAttribute("onClick", "return " + parent.m_item.getName().replace('.', '_') + "Popup(this.form)");
            this.setAttribute("value", "Search");
        }

        public boolean isVisible(PageState ps) {
            return !this.parent.m_search.isSelected(ps) && !this.parent.m_searchComponent.hasQuery(ps) && super.isVisible(ps);
        }
    }

    private class ItemFragment
    extends TextField {
        private ItemSearchWidget parent;

        public ItemFragment(ParameterModel parameter, ItemSearchWidget parent) {
            super(parameter);
            this.parent = parent;
            this.setReadOnly();
            this.setSize(35);
        }
    }
}

