/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TreeExpansionEvent;
import com.arsdigita.bebop.event.TreeExpansionListener;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.ItemSearchFolderBrowser;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.folder.FolderTree;
import com.arsdigita.cms.util.GlobalizationUtil;
import java.math.BigDecimal;

public class ItemSearchBrowsePane
extends CMSContainer
implements Resettable,
TreeExpansionListener,
ChangeListener,
FormProcessListener,
FormSubmissionListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearchBrowsePane.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    FolderSelectionModel m_folderSel;
    FolderTree m_tree;
    ItemSearchFolderBrowser m_browser;

    public ItemSearchBrowsePane() {
        this.setClassAttr("sidebarNavPanel");
        this.setAttribute("navbar-title", "Folders");
        Label l = new Label(GlobalizationUtil.globalize("cms.ui.folder_browser"));
        l.setClassAttr("heading");
        this.add((Component)l);
        this.m_folderSel = new FolderSelectionModel("folder");
        this.m_folderSel.addChangeListener(this);
        this.m_tree = new FolderTree(this.m_folderSel);
        this.m_tree.setClassAttr("navbar");
        this.m_tree.addTreeExpansionListener(this);
        this.add((Component)this.m_tree);
        CMSContainer container = new CMSContainer();
        container.setClassAttr("main");
        this.m_browser = new ItemSearchFolderBrowser(this.m_folderSel);
        container.add((Component)this.m_browser);
        container.add((Component)this.m_browser.getPaginator());
        this.add((Component)container);
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, this.m_folderSel.getStateParameter());
    }

    public void reset(PageState s) {
    }

    public ItemSearchFolderBrowser getFolderBrowser() {
        return this.m_browser;
    }

    public final FolderSelectionModel getFolderSelectionModel() {
        return this.m_folderSel;
    }

    protected void setSelectedFolder(PageState s, String key) {
        this.m_browser.getFolderSelectionModel().setSelectedKey(s, key);
        this.m_folderSel.setSelectedKey(s, key);
        Folder current = (Folder)this.m_folderSel.getSelectedObject(s);
        Folder parent = (Folder)current.getParent();
        if (parent != null) {
            BigDecimal id = parent.getID();
            this.m_tree.expand(id.toString(), s);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        PageState s = e.getPageState();
        this.m_folderSel.setSelectedKey(s, e.getNodeKey());
    }

    public void treeExpanded(TreeExpansionEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        Folder current = (Folder)this.m_folderSel.getSelectedObject(s);
        Folder parent = (Folder)current.getParent();
        this.m_browser.getPaginator().reset(s);
        if (parent != null) {
            BigDecimal id = parent.getID();
            this.m_tree.expand(id.toString(), s);
        }
    }

    public void process(FormSectionEvent e) {
        PageState s = e.getPageState();
    }

    public void submitted(FormSectionEvent e) {
        PageState s = e.getPageState();
    }
}

