/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.publishToFile.PublishToFile;
import com.arsdigita.cms.publishToFile.PublishToFileException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.Host;
import com.arsdigita.web.Web;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Utilities {
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$publishToFile$Utilities == null ? (class$com$arsdigita$cms$publishToFile$Utilities = Utilities.class$("com.arsdigita.cms.publishToFile.Utilities")) : class$com$arsdigita$cms$publishToFile$Utilities).getName());
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$Utilities;

    static String getMediaIndicator(String media) {
        if (media == null || "public".equals(media)) {
            return "";
        }
        return '$' + media;
    }

    static String getItemURL(ContentItem item) {
        Assert.assertNotNull((Object)item);
        ContentSection section = item.getContentSection();
        ContentItem working = item.getWorkingVersion();
        ContentItem liveItem = working.getLiveVersion();
        String url = "";
        s_log.debug((Object)("Getting live item for " + item.getID()));
        s_log.debug((Object)("Working is " + working.getID()));
        if (liveItem != null) {
            s_log.debug((Object)("getting url for item " + liveItem.getName() + " in section " + section.getName()));
            url = section.getItemResolver().generateItemURL(null, liveItem, section, "live");
            s_log.debug((Object)("Url is: " + url));
        } else {
            s_log.warn((Object)"liveItem is null");
        }
        return url;
    }

    public static String getItemLocation(ContentItem item) {
        return PublishToFile.stripSourceBase(Utilities.getItemURL(item));
    }

    public static boolean moveItem(Folder dstFolder, Folder srcFolder, ContentItem item) {
        if (Assert.isEnabled()) {
            Assert.assertTrue((item != null && srcFolder != null && dstFolder != null ? 1 : 0) != 0);
        }
        Host host = Host.retrieve((HttpHost)Web.getConfig().getHost());
        String dst = Utilities.validateLocation(dstFolder, true);
        if (item instanceof ContentBundle) {
            Assert.assertTrue((!"index".equals(item.getName()) ? 1 : 0) != 0, (String)"don't pass ContentBundle as Index Item, better to pass Folder");
            Utilities.moveBundle((ContentBundle)item, dst, host);
        } else {
            String path = item.getPath();
            if (path == null || path.equals("")) {
                return false;
            }
            ContentSection section = item.getContentSection();
            Assert.assertNotNull((Object)((Object)section));
            path = PublishToFile.stripSourceBase(section.getURL() + path);
            Assert.assertTrue((path != null && path.length() > 0 ? 1 : 0) != 0);
            File root = PublishToFile.getDestination(item.getSpecificObjectType()).getFile();
            String src = new File(root, path).getAbsolutePath();
            String cmd = "/bin/mv -f " + src + " " + dst;
            try {
                Utilities.executeCommand(cmd);
            }
            catch (PublishToFileException ex) {
                s_log.warn((Object)("Could not move folder on Fyle System, message: " + ex.getMessage()));
            }
        }
        Utilities.updateMovedItems(item, srcFolder, dstFolder, host);
        return true;
    }

    private static void moveBundle(ContentBundle bundle, String dstPath, Host host) {
        ItemCollection ic = bundle.getInstances();
        while (ic.next()) {
            if (!"live".equals(ic.getVersion())) continue;
            Utilities.moveItem(ic.getContentItem(), dstPath, host);
        }
        ic.close();
    }

    private static void moveItem(ContentItem item, String dstPath, Host host) {
        Assert.assertTrue((boolean)"live".equals(item.getVersion()), (String)("ContentItem item = " + item + " is not a live version"));
        String docRoot = PublishToFile.getDestination(item.getSpecificObjectType()).getFile().getAbsolutePath();
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.publishToFile.getRelatedFiles");
        query.setParameter("itemId", (Object)item.getID());
        query.setParameter("hostId", (Object)host.getID());
        while (query.next()) {
            String fileName = (String)query.get("fileName");
            Assert.assertNotNull((Object)fileName);
            fileName = docRoot + fileName;
            String cmd = "/bin/mv -f " + fileName + " " + dstPath;
            try {
                Utilities.executeCommand(cmd);
            }
            catch (PublishToFileException ex) {
                s_log.warn((Object)("Could not move file on File System, message: " + ex.getMessage() + ", item = " + item));
            }
        }
        query.close();
    }

    private static void updateMovedItems(ContentItem item, Folder srcFolder, Folder dstFolder, Host host) {
        Assert.assertTrue(("live".equals(item.getVersion()) && "live".equals(srcFolder.getVersion()) && "live".equals(dstFolder.getVersion()) ? 1 : 0) != 0);
        String srcPath = Utilities.getItemLocation(srcFolder);
        String dstPath = Utilities.getItemLocation(dstFolder);
        if (item instanceof Folder) {
            String itemPath = Utilities.getItemLocation(item);
            DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.publishToFile.moveFolder");
            operation.setParameter("newPrefix", (Object)dstPath);
            operation.setParameter("oldPrefix", (Object)srcPath);
            operation.setParameter("itemPath", (Object)itemPath);
            operation.setParameter("hostId", (Object)host.getID());
            operation.execute();
            operation.close();
        } else if (item instanceof ContentBundle) {
            ContentBundle bundle = (ContentBundle)item;
            ItemCollection ic = bundle.getInstances();
            while (ic.next()) {
                ContentItem moved = ic.getContentItem();
                Utilities.updateItem(moved.getID(), srcPath, dstPath, dstFolder.getID(), host);
            }
            ic.close();
        } else {
            Utilities.updateItem(item.getID(), srcPath, dstPath, dstFolder.getID(), host);
        }
    }

    private static void updateItem(BigDecimal itemId, String srcFolder, String dstFolder, BigDecimal newParentId, Host host) {
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.publishToFile.moveItem");
        operation.setParameter("newPrefix", (Object)dstFolder);
        operation.setParameter("oldPrefix", (Object)srcFolder);
        operation.setParameter("itemId", (Object)itemId);
        operation.setParameter("newParentId", (Object)newParentId);
        operation.setParameter("hostId", (Object)host.getID());
        operation.execute();
        operation.close();
    }

    private static String validateLocation(Folder folder, boolean makeNew) {
        Assert.assertNotNull((Object)folder);
        String fullPath = Utilities.getItemFullPath(folder);
        try {
            File file = new File(fullPath);
            if (!file.exists() && makeNew) {
                return file.mkdirs() ? fullPath : "";
            }
            return file.exists() ? fullPath : "";
        }
        catch (SecurityException ex) {
            s_log.warn((Object)"Security Exception raised .....");
            return "";
        }
    }

    public static void removeItems(Folder item) {
        if (item == null) {
            return;
        }
        Host host = Host.retrieve((HttpHost)Web.getConfig().getHost());
        String path = item.getPath();
        if (path == null || path.equals("")) {
            return;
        }
        ContentSection section = item.getContentSection();
        Assert.assertNotNull((Object)((Object)section));
        path = PublishToFile.stripSourceBase(section.getURL() + path);
        Assert.assertTrue((path != null && path.length() > 0 ? 1 : 0) != 0);
        path = '/' + path;
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.publishToFile.deleteFiles");
        operation.setParameter("prefix", (Object)path);
        operation.setParameter("hostId", (Object)host.getID());
        operation.execute();
        operation.close();
        String cmd = "/bin/rm -rf " + PublishToFile.getDestination("com.arsdigita.cms.ContentItem").getFile().getAbsolutePath() + path;
        try {
            Utilities.executeCommand(cmd);
        }
        catch (PublishToFileException ex) {
            s_log.warn((Object)("Could not delete folder on File System, message: " + ex.getMessage()));
        }
    }

    public static String getItemFullPath(ContentItem item) {
        Assert.assertNotNull((Object)item);
        File root = PublishToFile.getDestination(item.getSpecificObjectType()).getFile();
        String location = Utilities.getItemLocation(item);
        Assert.assertNotNull((Object)location);
        Assert.assertTrue((boolean)location.startsWith("/"));
        return new File(root, location).getAbsolutePath();
    }

    public static void executeCommand(String cmd) throws PublishToFileException {
        Process p;
        try {
            p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (InterruptedException e) {
            throw new PublishToFileException("interrupted when doing '" + cmd + "' : " + e.getMessage());
        }
        catch (IOException e) {
            throw new PublishToFileException("Error executing '" + cmd + "' : " + e.getMessage());
        }
        if (p.exitValue() != 0) {
            throw new PublishToFileException("Exit value was " + p.exitValue() + " when executing '" + cmd + "', should be 0");
        }
    }

    public static ContentItem getContentItem(BigDecimal itemID) {
        ContentItem item;
        Assert.assertNotNull((Object)itemID, (String)"You passed null as Item ID");
        OID oid = new OID("com.arsdigita.cms.ContentItem", (Object)itemID);
        try {
            item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException e) {
            throw new IllegalArgumentException("Item " + itemID + " does not exist.");
        }
        return item;
    }

    public static ContentItem getContentItemOrNull(BigDecimal itemID) {
        ContentItem item = null;
        OID oid = new OID("com.arsdigita.cms.ContentItem", (Object)itemID);
        if (itemID != null) {
            try {
                item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }
        return item;
    }

    public static String getAssetPath(Asset asset) {
        return Utilities.getAssetPath(asset, null);
    }

    public static String getAssetPath(Asset asset, Folder folder) {
        if (folder != null) {
            return Utilities.getItemLocation(folder);
        }
        MimeType mime = asset.getMimeType();
        if (mime == null) {
            throw new IllegalArgumentException("MIME Type for asset " + asset + " is null.");
        }
        String path = "/" + asset.getName() + "_" + asset.getID() + "." + mime.getFileExtension();
        s_log.debug((Object)("AssetPath is " + path));
        return path;
    }

    public static String stripJSP(String s) {
        String JSP = ".jsp";
        if (s.endsWith(".jsp")) {
            s = s.substring(0, s.length() - ".jsp".length());
        }
        return s;
    }

    public static Folder getLiveTarget(Folder target) {
        ContentItem live;
        ContentItem contentItem = live = "live".equals(target.getVersion()) ? target.getLiveVersion() : null;
        if (live == null) {
            LifecycleDefinition def = ContentTypeLifecycleDefinition.getLifecycleDefinition(target.getContentSection(), target.getContentType());
            target.publish(def, null);
            live = target.getLiveVersion();
        }
        return (Folder)live;
    }

    public static void updateContentSection(ContentItem item, ContentSection newSection) {
        Assert.assertNotNull((Object)item);
        Assert.assertNotNull((Object)((Object)newSection));
        ContentSection oldSection = item.getContentSection();
        if (oldSection.getID().equals(newSection.getID())) {
            return;
        }
        if (item instanceof Folder) {
            Utilities.updateFolderSection((Folder)item, oldSection, newSection);
        } else if (item instanceof ContentBundle) {
            Utilities.updateBundleSection((ContentBundle)item, newSection);
        } else {
            Utilities.updateItemSection(item, newSection);
        }
    }

    private static void updateFolderSection(Folder folder, ContentSection oldSection, ContentSection newSection) {
        Folder.ItemCollection ic = folder.getItems();
        while (ic.next()) {
            ContentItem item = ic.getContentItem();
            if (item instanceof Folder) {
                if (!oldSection.getID().equals(item.getContentSection().getID())) continue;
                Utilities.updateFolderSection((Folder)item, oldSection, newSection);
                continue;
            }
            if (item instanceof ContentBundle) {
                Utilities.updateBundleSection((ContentBundle)item, newSection);
                continue;
            }
            Utilities.updateItemSection(item, newSection);
        }
        Utilities.updateItemSection(folder, newSection);
    }

    private static void updateBundleSection(ContentBundle bundle, ContentSection newSection) {
        ItemCollection ic = bundle.getInstances();
        while (ic.next()) {
            Utilities.updateItemSection(ic.getContentItem(), newSection);
        }
        Utilities.updateItemSection(bundle, newSection);
    }

    private static void updateItemSection(ContentItem item, ContentSection newSection) {
        item.setContentSection(newSection);
        item.save();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

