/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.AbstractItemResolver;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.MasterPage;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.DispatcherHelper;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SimpleItemResolver
extends AbstractItemResolver
implements ItemResolver {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/SimpleItemResolver.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$dispatcher$SimpleItemResolver == null ? (class$com$arsdigita$cms$dispatcher$SimpleItemResolver = SimpleItemResolver.class$("com.arsdigita.cms.dispatcher.SimpleItemResolver")) : class$com$arsdigita$cms$dispatcher$SimpleItemResolver).getName());
    private static final String ADMIN_PREFIX = "admin";
    private static final String WORKSPACE_PREFIX = Utilities.getWorkspaceURL();
    private static MasterPage s_masterP = null;
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$SimpleItemResolver;

    public ContentItem getItem(ContentSection section, String url, String context) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("trying to get " + context + " item for url " + url));
        }
        String itemUrl = this.stripTemplateFromURL(url);
        ContentItem reqItem = (ContentItem)DispatcherHelper.getRequest().getAttribute("com.arsdigita.cms.dispatcher.item");
        if (reqItem != null) {
            s_log.info((Object)"found item in the request, returning it");
            return reqItem;
        }
        Folder rootFolder = section.getRootFolder();
        if (rootFolder == null) {
            s_log.info((Object)"no root folder found, returning null");
            return null;
        }
        if (context.equals("live")) {
            if ((rootFolder = (Folder)rootFolder.getLiveVersion()) == null) {
                s_log.info((Object)"no LIVE version of root folder found, returning null");
                return null;
            }
        } else if (!context.equals("draft")) {
            throw new RuntimeException("getItem: Invalid item resolver context " + context);
        }
        ContentItem item = this.getItem(itemUrl, rootFolder);
        return item;
    }

    public String getCurrentContext(PageState state) {
        String sectionURL;
        String url = state.getRequest().getRequestURI();
        ContentSection section = CMS.getContext().getContentSection();
        if (section != null && url.startsWith(sectionURL = section.getURL())) {
            url = url.substring(sectionURL.length());
        }
        if ((url = this.stripTemplateFromURL(url)).startsWith(ADMIN_PREFIX) || url.startsWith(WORKSPACE_PREFIX)) {
            return "draft";
        }
        return "live";
    }

    public ContentItem getItem(String url, Folder rootFolder) {
        ContentBundle indexItem;
        StringTokenizer tokenizer = new StringTokenizer(url, "/");
        String name = null;
        Folder oldFolder = null;
        while (rootFolder != null && tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken();
            oldFolder = rootFolder;
            rootFolder = (Folder)rootFolder.getItem(name, true);
        }
        if (tokenizer.hasMoreTokens()) {
            s_log.debug((Object)"no more tokens found, returning null");
            return null;
        }
        if (rootFolder != null && (indexItem = rootFolder.getIndexItem()) != null) {
            s_log.info((Object)"returning index item for folder");
            return indexItem;
        }
        if (name == null) {
            s_log.debug((Object)"no name found");
            return null;
        }
        return oldFolder.getItem(name, false);
    }

    private String generateDraftURL(BigDecimal itemId, ContentSection section) {
        return ContentItemPage.getItemURL(section.getFullPath() + "/", itemId, ContentItemPage.AUTHORING_TAB);
    }

    private String generateLiveURL(ContentItem item, ContentSection section, String templateContext) {
        String templateURLFrag = templateContext == null || templateContext.length() == 0 ? "" : "tem_" + templateContext + "/";
        return section.getPath() + "/" + templateURLFrag + item.getPath();
    }

    private String generatePreviewURL(ContentItem item, ContentSection section, String templateContext) {
        String templateURLFrag = templateContext == null || templateContext.length() == 0 ? "" : "tem_" + templateContext + "/";
        StringBuffer url = new StringBuffer();
        url.append(section.getPath()).append("/preview").append("/").append(templateURLFrag).append(item.getPath());
        return url.toString();
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context) {
        return this.generateItemURL(state, itemId, name, section, context, null);
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context, String templateContext) {
        if ("draft".equals(context)) {
            return this.generateDraftURL(itemId, section);
        }
        if ("live".equals(context)) {
            ContentItem item = new ContentItem(itemId);
            return this.generateLiveURL(item, section, templateContext);
        }
        if ("preview".equals(context)) {
            ContentItem item = new ContentItem(itemId);
            return this.generatePreviewURL(item, section, templateContext);
        }
        throw new RuntimeException((String)GlobalizationUtil.globalize("cms.dispatcher.unknown_context").localize() + context);
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context) {
        return this.generateItemURL(state, item, section, context, null);
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context, String templateContext) {
        if ("live".equals(context)) {
            return this.generateLiveURL(item, section, templateContext);
        }
        if ("draft".equals(context)) {
            return this.generateDraftURL(item.getID(), section);
        }
        if ("preview".equals(context)) {
            return this.generatePreviewURL(item, section, templateContext);
        }
        throw new RuntimeException((String)GlobalizationUtil.globalize("cms.dispatcher.unknown_context").localize() + context);
    }

    public CMSPage getMasterPage(ContentItem item, HttpServletRequest request) throws ServletException {
        if (s_masterP == null) {
            s_masterP = new MasterPage();
            s_masterP.init();
        }
        return s_masterP;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

