/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.dispatcher.ResourceHandler;
import com.arsdigita.cms.dispatcher.SimpleCache;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.JSPApplicationDispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceDispatcher
extends LockableImpl
implements Dispatcher {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/ServiceDispatcher.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String MAP_FILE = "WEB-INF/resources/cms-service-map.xml";
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$dispatcher$ServiceDispatcher == null ? (class$com$arsdigita$cms$dispatcher$ServiceDispatcher = ServiceDispatcher.class$("com.arsdigita.cms.dispatcher.ServiceDispatcher")) : class$com$arsdigita$cms$dispatcher$ServiceDispatcher).getName());
    private static HashMap s_pageClasses = new HashMap();
    private static SimpleCache s_pages = new SimpleCache();
    private Dispatcher m_notFoundHandler;
    private ArrayList m_trailingSlashList = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$ServiceDispatcher;

    public ServiceDispatcher() {
        this.requireTrailingSlash("");
        this.setNotFoundDispatcher((Dispatcher)JSPApplicationDispatcher.getInstance());
        this.readFromFile(MAP_FILE);
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        DeveloperSupport.startStage((String)"ServiceDispatcher.dispatch");
        String url = actx.getRemainingURLPart();
        String originalUrl = actx.getOriginalURL();
        if (this.m_trailingSlashList.contains(url) && !originalUrl.endsWith("/")) {
            DispatcherHelper.sendRedirect((HttpServletResponse)response, (String)(originalUrl + "/"));
            return;
        }
        this.checkUserAccess(request, response, actx);
        ResourceHandler page = this.getResource(url);
        if (page != null) {
            page.init();
            page.dispatch(request, response, actx);
        } else {
            this.m_notFoundHandler.dispatch(request, response, actx);
        }
        DeveloperSupport.endStage((String)"ServiceDispatcher.dispatch");
    }

    public final void setNotFoundDispatcher(Dispatcher d) {
        this.m_notFoundHandler = d;
    }

    public void requireTrailingSlash(String url) {
        this.m_trailingSlashList.add(url);
    }

    protected ResourceHandler getResource(String url) throws ServletException {
        String pageClassName;
        ResourceHandler page = (ResourceHandler)s_pages.get(url);
        if (page == null && (pageClassName = (String)s_pageClasses.get(url)) != null) {
            Class<?> pageClass;
            try {
                pageClass = Class.forName(pageClassName);
            }
            catch (ClassNotFoundException e) {
                s_log.error((Object)"error fetching class for ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            try {
                page = (ResourceHandler)pageClass.newInstance();
            }
            catch (InstantiationException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            page.init();
            s_pages.put(url, page);
        }
        return page;
    }

    protected void addResource(String url, String className) {
        s_pageClasses.put(url, className);
    }

    public static void releaseResource(String url) {
        s_pages.remove(url);
    }

    protected void checkUserAccess(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws ServletException {
    }

    protected void redirectToLoginPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String url = Util.getSecurityHelper().getLoginURL(req) + "?" + "return_url" + "=" + UserContext.encodeReturnURL((HttpServletRequest)req);
        try {
            LoginHelper.sendRedirect((HttpServletRequest)req, (HttpServletResponse)resp, (String)url);
        }
        catch (IOException e) {
            s_log.error((Object)"IO Exception", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private final void readFromFile(String file) {
        if (this.isLocked()) {
            s_log.error((Object)"error in readFromFile: Cannot configure resources more than once.");
            throw new RuntimeException("error in readFromFile: Cannot configure resources once the dispatcher is locked.");
        }
        XML.parseResource((String)file, (DefaultHandler)this.newParseConfigHandler(s_pageClasses));
        this.lock();
    }

    protected DefaultHandler newParseConfigHandler(Map map) {
        return new PageClassConfigHandler(map);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class PageClassConfigHandler
    extends DefaultHandler {
        private Map m_map;
        private StringBuffer m_buffer;
        private String m_url;
        private String m_className;

        public PageClassConfigHandler(Map map) {
            this.m_map = map;
            this.m_buffer = new StringBuffer();
        }

        public void characters(char[] ch, int start, int len) {
            for (int i = 0; i < len; ++i) {
                this.m_buffer.append(ch[start + i]);
            }
        }

        public void endElement(String uri, String localName, String qn) {
            if (qn.equals("url")) {
                this.m_url = this.m_buffer.toString().trim();
            } else if (qn.equals("page-class")) {
                this.m_className = this.m_buffer.toString().trim();
            } else if (qn.equals("url-mapping")) {
                this.m_map.put(this.m_url, this.m_className);
            }
            this.m_buffer = new StringBuffer();
        }
    }
}

