/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.caching.CacheTable;
import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.dispatcher.ItemXML;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.persistence.Filter;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ContentItemDispatcher
implements Dispatcher {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$dispatcher$ContentItemDispatcher == null ? (class$com$arsdigita$cms$dispatcher$ContentItemDispatcher = ContentItemDispatcher.class$("com.arsdigita.cms.dispatcher.ContentItemDispatcher")) : class$com$arsdigita$cms$dispatcher$ContentItemDispatcher).getName());
    private static CacheTable s_cache = new CacheTable("ContentItemDispatcherCache");
    public static Map s_templateResolverCache = Collections.synchronizedMap(new HashMap());
    protected ItemXML m_itemXML = new ItemXML();
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$ContentItemDispatcher;

    public void dispatch(final HttpServletRequest request, final HttpServletResponse response, final RequestContext actx) throws IOException, ServletException {
        Boolean bXMLMode = (Boolean)request.getAttribute("xmlMode");
        if (bXMLMode != null && bXMLMode.booleanValue()) {
            this.m_itemXML.dispatch(request, response, actx);
        } else {
            final ContentItem item = ContentItemDispatcher.getContentItem(request);
            final ContentSection section = (ContentSection)Web.getContext().getApplication();
            Assert.assertNotNull((Object)item);
            final String sTemplateURL = this.getTemplatePath(item, request, actx);
            CMSExcursion excursion = new CMSExcursion(){

                public void excurse() throws ServletException, IOException {
                    this.setContentSection(section);
                    this.setContentItem(item);
                    DispatcherHelper.setRequestContext((HttpServletRequest)request, (RequestContext)actx);
                    DispatcherHelper.forwardRequestByPath((String)sTemplateURL, (HttpServletRequest)request, (HttpServletResponse)response);
                }
            };
            excursion.run();
        }
    }

    public static ContentItem getContentItem(HttpServletRequest request) {
        return (ContentItem)request.getAttribute("com.arsdigita.cms.dispatcher.item");
    }

    private static synchronized void cachePut(BigDecimal contentItemID, String sTemplatePath) {
        s_cache.put(contentItemID, (Object)sTemplatePath);
    }

    private static synchronized void cacheRemove(BigDecimal contentItemID) {
        s_cache.remove(contentItemID);
    }

    public static void cacheRemove(ContentItem item) {
        if (item == null) {
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("removing cached entry for item " + item.getName() + " with ID " + item.getID()));
        }
        s_cache.remove(item.getID());
    }

    public static void cachePut(ContentItem item, Template t) {
        ContentSection section = item.getContentSection();
        String sPath = ContentItemDispatcher.getTemplatePath(section, t);
        if (item == null || item.getVersion().compareTo("live") != 0) {
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("updating mapping for item " + item.getName() + " with ID " + item.getID() + " in section " + section.getName() + " of type " + item.getContentType().getLabel() + " to template " + sPath));
        }
        ContentItemDispatcher.cachePut(item.getID(), sPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cachePut(ContentSection section, ContentType type, Template t) {
        s_log.debug((Object)("updating cache for section " + section.getName() + " and type " + type.getLabel()));
        Folder.ItemCollection items = section.getItems();
        BigDecimal typeID = type.getID();
        Filter filter = items.addFilter("type.id = :typeID");
        filter.set("typeID", (Object)typeID);
        Filter liveFilter = items.addFilter("version = 'live'");
        Filter itemsFilter = items.addNotInSubqueryFilter("id", "com.arsdigita.cms.ItemsWithTemplateMapping");
        itemsFilter.set("sectionId", (Object)section.getID());
        itemsFilter.set("typeId", (Object)type.getID());
        CacheTable cacheTable = s_cache;
        synchronized (cacheTable) {
            while (items.next()) {
                ContentItemDispatcher.cachePut(items.getContentItem(), t);
            }
        }
    }

    private static String getTemplatePath(ContentSection section, Template template) {
        String sep = File.separator;
        String sPath = ContentSection.getConfig().getTemplateRoot() + sep + section.getName() + sep + template.getPath();
        return sPath;
    }

    private static void updateTemplateCache(ContentSection section, ContentItem item, String sTemplatePath) {
        item = item.getLiveVersion();
        s_log.debug((Object)("updating mapping for item " + item.getName() + " with ID " + item.getID() + " in section " + item.getContentSection().getName() + " of type " + item.getContentType().getLabel() + " to template " + sTemplatePath));
        ContentItemDispatcher.cachePut(item.getID(), sTemplatePath);
    }

    private String cacheGet(BigDecimal key) {
        return (String)s_cache.get(key);
    }

    private String getTemplatePath(ContentItem item, HttpServletRequest req, RequestContext ctx) {
        String sPath = this.fetchTemplateURL(item, req, ctx);
        return sPath;
    }

    public String fetchTemplateURL(ContentItem item, HttpServletRequest request, RequestContext actx) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("fetching URL for item " + item.getName() + " with ID " + item.getID()));
        }
        ContentSection section = item.getContentSection();
        String templateURL = this.getTemplateResolver(section).getTemplate(section, item, request);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("templateURL is " + templateURL));
        }
        return templateURL;
    }

    public TemplateResolver getTemplateResolver(ContentSection section) {
        String name = section.getName();
        TemplateResolver ir = (TemplateResolver)s_templateResolverCache.get(name);
        if (ir == null) {
            ir = section.getTemplateResolver();
            s_templateResolverCache.put(name, ir);
        }
        return ir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

